package com.bokesoft.yigo.tools.dict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.struct.dict.ItemRow;
import com.bokesoft.yes.struct.dict.ItemTableBase;
import com.bokesoft.yes.tools.dic.DictTools;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.tools.ve.VE;

/**
 * 字典Item转换工具类
 */
public class ItemUtil {

	/**
	 * 处理DataTable转Item
	 * @param ve 环境变量
	 * @param itemKey 字典标识
	 * @param dts 数据库数据
	 * @return 字典缓存对象
	 * @throws Throwable 异常
	 */
	public static List<Item> createItems(VE ve, String itemKey, Map<String, DataTable> dts) throws Throwable {
		Item item = null;
		Map<Long, Item> map = new HashMap<Long, Item>();
		MetaDataObject dataObj = ve.getMetaFactory().getDataObject(itemKey);
		String mainTableKey = dataObj.getMainTableKey();
		DataTable dt = dts.get(mainTableKey);
		MetaTable table = dataObj.getTable(mainTableKey);

		for (String sKey : dts.keySet()) {
			table = dataObj.getTable(sKey);
			if (table.isT()) {
				continue;
			}
			boolean isMainTable = mainTableKey.equalsIgnoreCase(sKey);
			String OID = table.getSOIDColumn().getBindingDBColumnName();
			if (isMainTable){
				OID = table.getOIDColumn().getBindingDBColumnName();
			}
			dt = dts.get(sKey);
			// 遍历数据
			dt.beforeFirst();
			while (dt.next()) {
				long oid = TypeConvertor.toLong(dt.getObject(OID));
				if (oid <= 0) {
					continue;
				}
				//获取item
				item = map.get(oid);
				if(item == null){
					item = new Item(itemKey, oid);
					map.put(oid, item);
				}
				//处理缓存数据
				processData(ve, table, dt, item, isMainTable, oid, dts);
			}
		}

		for (String sKey : dts.keySet()) {
			table = dataObj.getTable(sKey);
			if (!table.isT()) {
				continue;
			}
			String srcTableKey = sKey.substring(0, sKey.length() - 2);
			if (!mainTableKey.equalsIgnoreCase(srcTableKey)) {
				continue;
			}
			boolean isMainTable = mainTableKey.equalsIgnoreCase(sKey);
			String OID = SystemField.SrcLangOID_SYS_KEY;
			dt = dts.get(sKey);
			// 遍历数据
			dt.beforeFirst();
			while (dt.next()) {
				long oid = TypeConvertor.toLong(dt.getObject(OID));
				if (oid <= 0) {
					continue;
				}
				//获取item
				item = map.get(oid);
				if(item == null){
					item = new Item(itemKey, oid);
					map.put(oid, item);
				}
				//处理缓存数据
				processData(ve, table, dt, item, isMainTable, 0L, null);
			}
		}

		List<Item> list = new ArrayList<Item>();
		
		String caption;
		for(Item item2 : map.values()){
			caption = getCaption(item2 , dataObj.getDisplayColumns());
			item2.setCaption(caption);
			item2.setShowCode(dataObj.getShowCode());
			DictTools.toI18nData(ve, item2);
			list.add(item2);
		}
		
		return list;
	}

	private static void processData(VE ve, MetaTable table, DataTable dt, Item item, boolean isMainTable, long oid, Map<String, DataTable> dts) throws Throwable {
		ItemRow row = new ItemRow();
        DataTable dt_T = null;
        for(MetaColumn col : table){
            if (!col.getCache()) {
            	  continue;
            }
            if (col.isSupportI18n()) {
                dt_T = dts.get(table.getKey() + MetaTable._T);
                
                int[] bks=  dt_T.fastFilter(new String[] {SystemField.SrcLangOID_SYS_KEY, SystemField.Lang_SYS_KEY},
                    new Object[] {oid, ve.getEnv().getLocale()});
//                    dt_T.setFilter(SystemField.SrcLangOID_SYS_KEY + "==" + oid + " && " + SystemField.Lang_SYS_KEY
//                            + "=='" + ve.getEnv().getLocale() + "'");
//                    dt_T.filter();
                if (bks.length == 1) {
                    // 当前语言匹配成功
                } else {
                    // 取第一条维护的
                    bks = dt_T.fastFilter(new String[] {SystemField.SrcLangOID_SYS_KEY}, new Object[] {oid});
//                        dt_T.setFilter(SystemField.SrcLangOID_SYS_KEY + "==" + oid);
//                        dt_T.filter();
                    dt_T.setSort(SystemField.OID_SYS_KEY, true);
                    dt_T.sort();
                }
                
                if (bks.length == 0) {
                    continue;
                }
//                    dt_T.first();
                row.setValue(col.getKey(), dt_T.getObject(bks[0], col.getBindingDBColumnName()));
                
//                    dt_T.setFilter("");
//                    dt_T.filter();
            } else {
                row.setValue(col.getKey(), dt.getObject(col.getBindingDBColumnName()));
            }
        }
        
        if (dt_T != null) {
            dt_T.setFilter("");
            dt_T.filter();
        }
		String sKey = table.getKey();
		int tableMode = table.getTableMode();
		ItemTableBase tb = item.getItemTable(sKey);
		if (tb == null) {
			tb = new ItemTableBase(item.getItemKey());
			tb.setKey(sKey);
			tb.setTableMode(tableMode);
			tb.addItemRow(row);
			item.addItemTableBase(tb , isMainTable);
		}else{
			tb.addItemRow(row);
		}
	}

	private static String getCaption(Item item , List<MetaColumn> displayFields){
		StringBuffer sb = new StringBuffer();
		if(displayFields != null && displayFields.size() > 0){
			for(int i = 0 ; i < displayFields.size() ; i ++){
				if(i > 0 ){
					sb.append(" ");
				}
				sb.append(TypeConvertor.toString(item.getValue(displayFields.get(i).getKey())));
			}
		}else{
			sb.append(TypeConvertor.toString(item.getValue(SystemField.CODE_DICT_KEY)))
					.append(" ")
					.append(TypeConvertor.toString(item.getValue(SystemField.NAME_DICT_KEY)));
		}

		return sb.toString();
	}

	/**
	 * JSONArray 转 字典缓存集合
	 * @param items 字典缓存jsonarray
	 * @return 字典缓存集合
	 * @throws Throwable 异常
	 */
	public static List<Item> getItems(JSONArray items) throws Throwable {
		List<Item> list = null;
		if(items != null){
			list = new ArrayList<Item>();
			for(int i = 0 ; i < items.length() ; i ++){
				JSONObject itemObj = items.getJSONObject(i);
				Item item = new Item();
				item.fromJSON(itemObj);
				list.add(item);
			}
		}
		return list;
	}
}
