package com.bokesoft.yigo.tools.dict;

import java.util.List;

import com.bokesoft.yigo.common.json.JSONSerializable;

/**
 * 字典过滤条件接口
 * @author zhufw
 *
 */
public interface IItemFilter extends JSONSerializable {
	
	/**
	 * 表单key
	 * @return 表单标识
	 */
	public String getFormKey();
	
	/**
	 * 字段key
	 * @return 字段
	 */
	public String getFieldKey();
	
	/**
	 * 过滤条件index
	 * @return 过滤条件序号
	 */
	public int getFilterIndex();

	/**
	 * 字典itemKey
	 * @return 字典标识
	 */
	public String getItemKey();
	
	/**
	 * 过滤条件 字段对应的值
	 * @return 值集合
	 */
	public List<Object> getFilterValues();
	
	/**
	 * 获得动态单元格类型字段
	 * @return 单元格动态类型定义
	 */
	public String getTypeDefKey();

	/**
	 * 设置动态单元格类型字段
	 * @param typeDefKey
	 */
	public void setTypeDefKey(String typeDefKey);
}
