package com.bokesoft.yigo.cache;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.bokesoft.yes.tools.cache.ICacheCallback;

/**
 * 缓存接口
 * 
 * @param <V> 值类型
 */
public interface ICache<V> {

	/**
	 * 设值
	 * 
	 * @param key   关键字
	 * @param value 值
	 */
	public void put(String key, V value);

	/**
	 * 取值
	 * 
	 * @param key 关键字
	 * @return 值
	 */
	public V get(String key);

	/**
	 * 是否包含
	 * 
	 * @param key 关键字
	 * @return 是否包含
	 */
	public boolean contains(String key);

	/**
	 * 根据关键字删除
	 * 
	 * @param key 关键字
	 */
	public void remove(String key);

	/**
	 * 根据多个关键字删除
	 * 
	 * @param keys 关键字
	 */
	public void removeAll(List<String> keys);

	/**
	 * 获取关键字
	 * 
	 * @return 关键字
	 */
	public Set<String> getKeys();

	/**
	 * 清空缓存
	 */
	public void clear();

	/**
	 * 缓存个数
	 * 
	 * @return 缓存个数
	 */
	public long size();

	/**
	 * 是否为空集合
	 * 
	 * @return 是否为空集合
	 */
	public boolean isEmpty();

	/**
	 * 根据关键字获取缓存
	 * 
	 * @param keys 关键字
	 * @return 缓存
	 */
	public Map<String, V> getAll(List<String> keys);

	/***
	 * 查找分组id
	 * 
	 * @param keysArray 键值数组
	 * @return 分组id数组
	 */
	public Long[] findGroupIds(Object[][] keysArray);

	/***
	 * 插入分组id
	 * 
	 * @param keysArray 键值数组
	 * @param groupIds  分组id数组
	 * @return 插入是否成功，true：成功；false：失败
	 */
	public Boolean insertGroupIds(Object[][] keysArray, Long[] groupIds);

	/**
	 * 自加 value(可以为正，可以为负)
	 * 
	 * @param key
	 * @param value
	 * @return
	 */
	public long incr(String key, long step, ICacheCallback initValueCallback);
}
