/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.variant;

import com.bokesoft.yigo.common.json.JSONSerializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class VariantItem
implements JSONSerializable {
    private int option = -1;
    private List<String> values;

    public VariantItem(int option) {
        this.option = option;
        this.values = new ArrayList<String>();
    }

    public VariantItem(JSONObject o) {
        try {
            this.fromJSON(o);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public void setValue(int index, String value) {
        this.values.set(index, value);
    }

    public int size() {
        return this.values.size();
    }

    public String getValue(int index) {
        return this.values.get(index);
    }

    public List<String> getValues() {
        return this.values;
    }

    public void clear() {
        this.values.clear();
    }

    public int getOption() {
        return this.option;
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put("option", this.option);
        JSONArray values = new JSONArray();
        for (String value : this.values) {
            values.put((Object)value);
        }
        o.put("values", (Object)values);
        return o;
    }

    public void fromJSON(JSONObject jsonObj) {
        this.option = jsonObj.optInt("option");
        this.values = new ArrayList<String>();
        JSONArray arr = new JSONArray(jsonObj.optString("values"));
        int size = arr.length();
        for (int i = 0; i < size; ++i) {
            this.values.add(arr.optString(i));
        }
    }
}

