/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.rights;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EntryRights
implements JSONSerializable {
    private List<String> entryKeys = new ArrayList<String>();
    private boolean hasAllRights = false;

    public boolean hasEntryRights(String entryKey) {
        if (this.hasAllRights) {
            return true;
        }
        return this.entryKeys.contains(entryKey);
    }

    public List<String> getRightsList() {
        return this.entryKeys;
    }

    public JSONObject toJSON() throws SerializationException, JSONException {
        JSONObject jsonObj = new JSONObject();
        if (this.hasAllRights) {
            jsonObj.put("allRights", true);
        } else {
            jsonObj.put("allRights", false);
            JSONArray entryKeyArray = new JSONArray();
            for (String entryKey : this.entryKeys) {
                entryKeyArray.put((Object)entryKey);
            }
            jsonObj.put("entryKeys", (Object)entryKeyArray);
        }
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
        this.hasAllRights = jsonObj.getBoolean("allRights");
        if (!this.hasAllRights) {
            JSONArray entryKeyArray = jsonObj.getJSONArray("entryKeys");
            this.entryKeys.clear();
            for (int i = 0; i < entryKeyArray.length(); ++i) {
                String entryKey = entryKeyArray.getString(i);
                this.entryKeys.add(entryKey);
            }
        }
    }

    public void addEntryKey(String entryKey) {
        if (this.hasAllRights) {
            return;
        }
        if (entryKey.equalsIgnoreCase("*")) {
            this.hasAllRights = true;
        } else if (!this.entryKeys.contains(entryKey)) {
            this.entryKeys.add(entryKey);
        }
    }

    public void setAllRights(boolean b) {
        this.hasAllRights = b;
    }

    public boolean hasAllRights() {
        return this.hasAllRights;
    }

    public void merge(EntryRights er) {
        if (er == null) {
            return;
        }
        if (this.hasAllRights) {
            return;
        }
        if (er.hasAllRights()) {
            this.hasAllRights = true;
            return;
        }
        this.entryKeys.removeAll(er.getRightsList());
        this.entryKeys.addAll(er.getRightsList());
    }
}

