/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.document;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaTableSource;
import com.bokesoft.yigo.struct.document.SolrMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TableFilterDetail
implements JSONSerializable {
    private String tableKey = "";
    private StringHashMap<Object> conditionValueMap = null;
    private ArrayList<Object> paraValues = null;
    private int startRow = 0;
    private int maxRows = 0;
    private long OID = -1L;
    private String sourceKey = "";
    private int pageIndicatorCount = 1;
    private boolean ignoreLoad = false;
    private MetaTableSource source = null;
    private SolrMap solrMap = null;
    private ArrayList<String> sortList = null;
    private ArrayList<Boolean> sortTypeList = null;
    private Boolean queryTotalRowCount = null;

    public TableFilterDetail() {
    }

    public TableFilterDetail(String tableKey) {
        this.tableKey = tableKey;
    }

    public void setSource(MetaTableSource source) {
        this.source = source;
    }

    public MetaTableSource getSource() {
        return this.source;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void addFieldValueCondition(String fieldKey, Object value) {
        if (this.conditionValueMap == null) {
            this.conditionValueMap = new StringHashMap();
        }
        this.conditionValueMap.put((Object)fieldKey, value);
    }

    public void appendParaValue(Object value) {
        if (this.paraValues == null) {
            this.paraValues = new ArrayList();
        }
        this.paraValues.add(value);
    }

    public Object getParaValue(int index) {
        return this.paraValues.get(index);
    }

    public boolean containFieldValue(String fieldKey) {
        return this.conditionValueMap == null ? false : this.conditionValueMap.containsKey((Object)fieldKey);
    }

    public Object getFieldValue(String fieldKey) {
        return this.conditionValueMap.get((Object)fieldKey);
    }

    public void removeFieldValueCondition(String fieldKey) {
        if (this.conditionValueMap == null) {
            return;
        }
        this.conditionValueMap.remove((Object)fieldKey);
    }

    public void clearFieldValueCondition() {
        if (this.conditionValueMap == null) {
            return;
        }
        this.conditionValueMap.clear();
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getEndRow() {
        return this.startRow + this.maxRows * this.pageIndicatorCount;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setOID(long OID) {
        this.OID = OID;
    }

    public long getOID() {
        return this.OID;
    }

    public SolrMap getSolrMap() {
        return this.solrMap;
    }

    public void setSolrMap(SolrMap solrMap) {
        this.solrMap = solrMap;
    }

    public ArrayList<String> getSortList() {
        return this.sortList;
    }

    public ArrayList<Boolean> getSortTypeList() {
        return this.sortTypeList;
    }

    public void addOrderField(String fieldKey, Boolean value) {
        int index;
        if (this.sortList == null) {
            this.sortList = new ArrayList();
            this.sortTypeList = new ArrayList();
        }
        if ((index = this.sortList.indexOf(fieldKey)) > -1) {
            this.sortList.remove(index);
            this.sortTypeList.remove(index);
        }
        this.sortList.add(fieldKey);
        this.sortTypeList.add(value);
    }

    public void clearOrderField() {
        if (this.sortList == null) {
            this.sortList = new ArrayList();
            this.sortTypeList = new ArrayList();
        }
        this.sortList.clear();
        this.sortTypeList.clear();
    }

    public String getSortStr(Callback<String, String> callBack) throws Throwable {
        StringBuilder SQL = new StringBuilder(" ");
        int size = this.sortList.size();
        for (int i = 0; i < size; ++i) {
            SQL.append((String)callBack.call((Object)this.sortList.get(i)));
            if (!this.sortTypeList.get(i).booleanValue()) {
                SQL.append(" DESC");
            }
            SQL.append(",");
        }
        SQL.delete(SQL.length() - 1, SQL.length());
        SQL.append(" ");
        return SQL.toString();
    }

    public boolean existSort() {
        return this.sortList != null && !this.sortList.isEmpty();
    }

    public JSONObject toJSON() throws SerializationException, JSONException {
        JSONObject tableFilterObj = new JSONObject();
        tableFilterObj.put("tableKey", (Object)this.tableKey);
        tableFilterObj.put("startRow", this.startRow);
        tableFilterObj.put("maxRows", this.maxRows);
        tableFilterObj.put("OID", this.OID);
        tableFilterObj.put("SourceKey", (Object)this.sourceKey);
        tableFilterObj.put("indicatorCount", this.pageIndicatorCount);
        if (this.solrMap != null) {
            try {
                JSONObject jsonObj = this.solrMap.toJSON();
                tableFilterObj.put("solrMap", (Object)jsonObj);
            }
            catch (Throwable jsonObj) {
                // empty catch block
            }
        }
        JSONObject fieldValue = new JSONObject();
        if (this.conditionValueMap != null) {
            for (Map.Entry e : this.conditionValueMap.entrySet()) {
                String fieldKey = (String)e.getKey();
                Iterator<String> v = e.getValue();
                fieldValue.put(fieldKey, v);
            }
        }
        tableFilterObj.put("fieldValues", (Object)fieldValue);
        JSONArray sortArray = new JSONArray();
        if (this.sortList != null) {
            for (String value : this.sortList) {
                sortArray.put((Object)value);
            }
        }
        tableFilterObj.put("OrderField", (Object)sortArray);
        JSONArray sortTypeArray = new JSONArray();
        if (this.sortTypeList != null) {
            for (Boolean value : this.sortTypeList) {
                sortTypeArray.put((Object)value);
            }
        }
        tableFilterObj.put("OrderFieldType", (Object)sortTypeArray);
        return tableFilterObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
        this.tableKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"tableKey", (String)"");
        this.startRow = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"startRow", (int)0);
        this.maxRows = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"maxRows", (int)0);
        this.OID = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"OID", (int)-1);
        this.sourceKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"SourceKey", (String)"");
        this.pageIndicatorCount = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"indicatorCount", (int)1);
        JSONObject mapObject = jsonObj.optJSONObject("solrMap");
        if (mapObject != null) {
            try {
                this.solrMap = new SolrMap();
                this.solrMap.fromJSON(mapObject);
            }
            catch (Throwable e) {
                this.solrMap = null;
            }
        }
        this.conditionValueMap = new StringHashMap();
        JSONObject fieldValues = jsonObj.optJSONObject("fieldValues");
        if (fieldValues != null && fieldValues.length() > 0) {
            Iterator it = fieldValues.keys();
            while (it.hasNext()) {
                String key = TypeConvertor.toString(it.next());
                Object value = fieldValues.get(key);
                this.conditionValueMap.put((Object)key, value);
            }
        }
        this.sortList = new ArrayList();
        JSONArray sortArray = jsonObj.getJSONArray("OrderField");
        for (int i = 0; i < sortArray.length(); ++i) {
            this.sortList.add(sortArray.getString(i));
        }
        this.sortTypeList = new ArrayList();
        JSONArray sortTypeArray = jsonObj.getJSONArray("OrderFieldType");
        for (int i = 0; i < sortTypeArray.length(); ++i) {
            this.sortTypeList.add(sortTypeArray.getBoolean(i));
        }
    }

    public String getTableKey() {
        return this.tableKey;
    }

    public boolean isLimit() {
        return this.maxRows > 0;
    }

    public int getPageIndicatorCount() {
        return this.pageIndicatorCount;
    }

    public void setPageIndicatorCount(int pageIndicatorCount) {
        this.pageIndicatorCount = pageIndicatorCount;
    }

    public ArrayList<Object> getParaValues() {
        return this.paraValues;
    }

    public void setParaValues(ArrayList<Object> paraValues) {
        this.paraValues = paraValues;
    }

    public void setIgnoreLoad(boolean b) {
        this.ignoreLoad = b;
    }

    public boolean isIgnoreLoad() {
        return this.ignoreLoad;
    }

    public void setQueryTotalRowCount(Boolean b) {
        this.queryTotalRowCount = b;
    }

    public Boolean needQueryTotalRowCount() {
        return this.queryTotalRowCount;
    }

    protected Object clone() {
        TableFilterDetail newObject = new TableFilterDetail();
        newObject.tableKey = this.tableKey;
        newObject.conditionValueMap = this.conditionValueMap == null ? null : (StringHashMap)this.conditionValueMap.clone();
        newObject.paraValues = this.paraValues == null ? null : (ArrayList)this.paraValues.clone();
        newObject.startRow = this.startRow;
        newObject.maxRows = this.maxRows;
        newObject.OID = this.OID;
        newObject.sourceKey = this.sourceKey;
        newObject.pageIndicatorCount = this.pageIndicatorCount;
        newObject.ignoreLoad = this.ignoreLoad;
        newObject.source = this.source == null ? null : (MetaTableSource)this.source.clone();
        newObject.solrMap = this.solrMap == null ? null : (SolrMap)this.solrMap.clone();
        newObject.sortList = this.sortList == null ? null : (ArrayList)this.sortList.clone();
        newObject.queryTotalRowCount = this.queryTotalRowCount;
        newObject.sortTypeList = this.sortTypeList == null ? null : (ArrayList)this.sortTypeList.clone();
        return newObject;
    }
}

