/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.datatable;

import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.Index;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Indexes {
    private List<Index> indexes;
    private DataTable rst;
    private HashSet<Integer> updateBookmarks;
    private int curUpdateBookmark = -1;
    private List<Integer> insertBookmarks;
    private List<Row> deleteRows;

    public Indexes(DataTable rst) {
        this.rst = rst;
    }

    public int[] getFilterRowIndexes(String[] filterColumns, Object[] filterValues) throws Throwable {
        if (filterColumns.length == 0) {
            int size = this.rst.size();
            int[] result = new int[size];
            for (int i = 0; i < size; ++i) {
                result[i] = i;
            }
            return result;
        }
        return this.getIndex(filterColumns).filter(filterValues);
    }

    public Object[][] getDistinctValues(String[] filterColumns) throws Throwable {
        return this.getIndex(filterColumns).getDistinctKeyValues();
    }

    private synchronized Index getIndex(String[] filterColumns) {
        if (this.updateBookmarks != null || this.insertBookmarks != null || this.deleteRows != null) {
            for (Index index : this.indexes) {
                index.updateIndex(this.updateBookmarks, this.insertBookmarks, this.deleteRows);
            }
            this.updateBookmarks = null;
            this.insertBookmarks = null;
            this.deleteRows = null;
            this.curUpdateBookmark = -1;
        }
        if (this.indexes == null) {
            this.indexes = new ArrayList<Index>();
        }
        for (Index index : this.indexes) {
            if (!index.isSatisfy(filterColumns)) continue;
            return index;
        }
        Index newIndex = new Index(this.rst, filterColumns);
        this.indexes.add(newIndex);
        return newIndex;
    }

    public synchronized void updateBookmark(int bookmark) {
        if (this.curUpdateBookmark == bookmark || this.indexes == null) {
            return;
        }
        if (this.updateBookmarks == null) {
            this.updateBookmarks = new HashSet();
        }
        this.updateBookmarks.add(bookmark);
        this.curUpdateBookmark = bookmark;
    }

    public synchronized void insertBookmark(int bookmark) {
        if (this.indexes == null) {
            return;
        }
        if (this.insertBookmarks == null) {
            this.insertBookmarks = new ArrayList<Integer>();
        }
        this.insertBookmarks.add(bookmark);
        this.curUpdateBookmark = bookmark;
    }

    public synchronized void deleteBookmark(Row row) {
        if (this.indexes == null) {
            return;
        }
        if (this.deleteRows == null) {
            this.deleteRows = new ArrayList<Row>();
        }
        this.deleteRows.add(row);
    }

    public synchronized void recoverBookmark(Row row) {
        if (this.indexes == null) {
            return;
        }
        if (!this.deleteRows.remove(row)) {
            this.insertBookmark(row.getBookmark());
            this.curUpdateBookmark = -1;
        }
        this.updateBookmark(row.getBookmark());
    }

    public synchronized void clear() {
        if (this.indexes == null) {
            return;
        }
        for (Index index : this.indexes) {
            index.clear();
        }
        this.indexes.clear();
    }
}

