/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.struct.document;

import com.bokesoft.yes.struct.document.IJSONHandler;
import com.bokesoft.yes.struct.document.JSONTokenizer;
import com.bokesoft.yigo.struct.document.Document;
import java.util.HashMap;
import java.util.Stack;

public class JSONUtil {
    private static HashMap<String, Integer> documentMap = null;
    private static final int document_object_key = 0;
    private static final int document_mainTableKey = 1;
    private static final int document_expand_data_class = 2;
    private static final int document_expand_data = 3;
    private static final int document_state = 4;
    private static final int document_expand_data_type = 5;
    private static final int document_table_list = 6;
    private static final int E_JSONObject = 0;
    private static final int E_JSONArray = 1;

    public static void fromJSON(Document document, String s) {
        JSONTokenizer t = new JSONTokenizer(s);
        int id = t.next();
        String token = t.getToken();
        Stack<Document> handlerStack = new Stack<Document>();
        Stack<Integer> typeStack = new Stack<Integer>();
        IJSONHandler top = null;
        int type = -1;
        String attrID = "";
        boolean hasColon = false;
        while (id != -1) {
            switch (id) {
                case 0: {
                    if (top == null) {
                        top = document;
                    } else {
                        handlerStack.add((Document)top);
                        typeStack.add(type);
                        top = top.newHandler(attrID);
                    }
                    type = 0;
                    attrID = "";
                    hasColon = false;
                    break;
                }
                case 4: 
                case 5: {
                    if (type == 0) {
                        if (hasColon) {
                            top.putAttr(attrID, token);
                            attrID = "";
                        } else {
                            attrID = token;
                        }
                    } else {
                        top.putAttr("", token);
                    }
                    hasColon = false;
                    break;
                }
                case 2: {
                    handlerStack.add((Document)top);
                    typeStack.add(type);
                    top = top.newHandler(attrID);
                    type = 1;
                    attrID = "";
                    hasColon = false;
                    break;
                }
                case 1: 
                case 3: {
                    Document tmpHandler = top;
                    top.endHandler();
                    if (handlerStack.isEmpty()) {
                        top = null;
                    } else {
                        top = (IJSONHandler)handlerStack.pop();
                        type = (Integer)typeStack.pop();
                    }
                    if (top == null) break;
                    top.endChildHandler(tmpHandler);
                    break;
                }
                case 7: {
                    hasColon = true;
                }
            }
            id = t.next();
            token = t.getToken();
        }
    }

    static {
        documentMap = new HashMap();
        documentMap.put("object_key", 0);
        documentMap.put("mainTableKey", 1);
        documentMap.put("expand_data_class", 2);
        documentMap.put("expand_data", 3);
        documentMap.put("state", 4);
        documentMap.put("expand_data_type", 5);
        documentMap.put("table_list", 6);
    }
}

