/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.struct.dict;

import com.bokesoft.yes.struct.dict.ItemTableMetaData;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDictQueryStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang3.StringUtils;

public class ItemTableMetaDatas
extends ConcurrentSkipListMap<String, ItemTableMetaData> {
    private static final long serialVersionUID = 1L;
    private String itemKey;
    private String mainTableKey;
    private int type;
    private Map<String, List<String>> i18nColumns = new HashMap<String, List<String>>();
    private String content = null;
    private List<String> displayColumns;
    private List<String> queryColumns;
    private int dictCacheCheckMode;

    public ItemTableMetaDatas(MetaDataObject dataObj) {
        this.itemKey = StringUtils.isEmpty((CharSequence)dataObj.getExtend()) ? dataObj.getKey() : dataObj.getExtend();
        this.mainTableKey = dataObj.getMainTableKey();
        MetaDictQueryStatement dictQueryStatement = dataObj.getDictQueryStatement();
        if (dictQueryStatement != null) {
            this.content = dictQueryStatement.getContent();
        }
        this.dictCacheCheckMode = dataObj.getDictCacheCheckMode();
        List cols = dataObj.getDisplayColumns();
        if (cols != null) {
            this.displayColumns = new ArrayList<String>();
            for (MetaColumn col : cols) {
                this.displayColumns.add(col.getBindingDBColumnName());
            }
        }
        if ((cols = dataObj.getQueryColumns()) != null) {
            this.queryColumns = new ArrayList<String>();
            for (MetaColumn col : cols) {
                this.queryColumns.add(col.getBindingDBColumnName());
            }
        }
    }

    public void init() {
        for (ItemTableMetaData table : this.values()) {
            this.i18nColumns.put(table.getKey(), table.getI18nColumns());
        }
    }

    public Map<String, List<String>> getI18nColumns() {
        return this.i18nColumns;
    }

    public ItemTableMetaData getMainTable() {
        return (ItemTableMetaData)this.get(this.mainTableKey);
    }

    public String getMainTableName() {
        String tableName = ((ItemTableMetaData)this.get(this.mainTableKey)).getTableName();
        return tableName;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public void setSecondaryType(int type) {
        this.type = type;
    }

    public int getSecondaryType() {
        return this.type;
    }

    public String getQueryStatement() {
        return this.content;
    }

    public int getDictCacheCheckMode() {
        return this.dictCacheCheckMode;
    }

    public List<String> getDisplayColumns() {
        return this.displayColumns;
    }

    public List<String> getQueryColumns() {
        return this.queryColumns;
    }
}

