package com.bokesoft.yigo.struct.rights;

import java.util.concurrent.ConcurrentHashMap;

public class DictRightsCache {
	private ConcurrentHashMap<String, DictRights> caches = new ConcurrentHashMap<String, DictRights>();
	
	public DictRights getDictRights(String itemKey){
		return caches.get(itemKey);	
	}

	public boolean containsKey(String itemKey) {
		return caches.containsKey(itemKey);
	}
	
	public void put(String itemKey , DictRights dictRights) {
		caches.put(itemKey, dictRights);
	}
	
	public void remove(String itemKey) {
		if (caches.containsKey(itemKey))
			caches.remove(itemKey);
	}
	
//	/**
//	 * 转换为json对象
//	 * 
//	 * @return json对象
//	 */
//	public JSONObject toJSON() throws SerializationException {
//		JSONObject jsonObj = new JSONObject();
//
//		return jsonObj;
//		
//	}
//	
//	/**
//	 * 从JSON对象获得对应的属性
//	 * 
//	 * @param jsonObj
//	 *            json对象
//	 * @throws StructException
//	 */
//	public void fromJSON(JSONObject jsonObj) throws SerializationException {
//
//	}
}
