package com.bokesoft.yigo.struct.preference;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.json.JSONObject;

import com.bokesoft.yigo.common.json.JSONSerializable;

public class Preference implements JSONSerializable,Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Map<String, Object> map = null;
	
	public Preference() {
	}

	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject o = new JSONObject();
				
		if(map != null) {
			Iterator<String> it = map.keySet().iterator();
			while(it.hasNext()) {
				String s = it.next();
				o.put(s, map.get(s));
			}
		}
		return o;
	}

	@Override
	public void fromJSON(JSONObject json) throws Throwable {
		if(map == null) {
			map = new HashMap<String, Object>();
			Iterator<?> it = json.keys();
			Object value = null;
			while(it.hasNext()) {
				Object o = it.next();
				if(o instanceof String ) {
					value = json.opt((String) o);
					map.put((String) o, value);
				}
			}
		}
	}
	
	public Set<String> keys(){
		return this.map.keySet();
	}

}
