package com.bokesoft.yigo.struct.i18n;

import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.i18n.LocaleStringTable;

public class StringTable {
	/** 游标越界 */
	public static final String OutOfBoubds = "OutOfBoubds";
	/** JSON数组中列的数量与表格配置定义不符 */
	public static final String ColumnNumberError = "ColumnNumberError";
	/** 未定义的数据类型 */
	public static final String Undefined = "Undefined";
	/** 未找到指定列 */
	public static final String UnfindedColumn = "UnfindedColumn";
	/** 列的键值错误 */
	public static final String ColumnKeyError = "ColumnKeyError";
	/** 二进制字段不支持排序操作 */
	public static final String CannotSort = "CannotSort";
	/** 列值克隆错误 */
	public static final String ColumnCloneError = "ColumnCloneError";
	/** 列长度错误 */
	public static final String ColumnLengthError = "ColumnLengthError";

	
	private static LocaleStringTable stringTable = null;

	public static String getString(ILocale locale, String section, String key) {
		String string = null;
		if (stringTable == null) {
			stringTable = new LocaleStringTable(StringTable.class);
		}
		string = stringTable.getString(locale, "Struct", key);
		return string;
	}
}
;