package com.bokesoft.yigo.struct.expand;

import java.util.List;

import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.struct.expand.processor.DimensionItem;

public interface IExpandWork<S extends IExpandSourceField<F>, F extends IExpandDimensionField> {
	
	public void doWork(List<String> fixedFieldKeys, List<DimensionItem<IPairItem, S, F>> colRootDimensionItems,
			List<DimensionItem<IPairItem, S, F>> rowRootDimensionItems);
	
	default String getExpandTargetKey(String sourceKey) {
		return "__expand__" + sourceKey;
	}
}
