package com.bokesoft.yigo.struct.dict;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.struct.dict.DictJSONConstants;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;

/**
 * ItemData的扩充 ， 主要用于web的返回值， 
 * 除了itemKey oid 还有NodeType Enable 以及MetaDataObject 中定义的DisplayColumns
 * @author zhufw
 *
 */
public class BaseItem implements JSONSerializable{
	private String itemKey;
	private long oid;
	private String caption;
	// 多语种caption
	private Map<String, String> i18nCaptions;
	private int enable;
	private int nodeType;
	// 根據displaycolumn设置显示code或useCode
	private String showCode;
	
	private Map<String , Object> props = null;
	
	public BaseItem(JSONObject jsonObj){
		try {
			fromJSON(jsonObj);
		} catch (Throwable e) {
			throw new SerializationException(SerializationException.JSON_DATA_ERROR ,"BaseItem json 序列化错误:"+jsonObj);
		}
	}
	
	public BaseItem(String itemKey , long oid){
		this.itemKey = itemKey;
		this.oid = oid;
		props = new HashMap<String,Object>();
	}
	
	public void setOID(long oid){
		this.oid = oid;
	}
	
	public long getOID(){
		return this.oid;
	}
	
	public void setItemKey(String itemKey){
		this.itemKey = itemKey;
	}
	
	public String getItemKey(){
		return this.itemKey;
	}
	
	public void addI18nCaption(Map<String, String> map) {
		if(map == null) {
			return;
		}
		if(i18nCaptions == null) {
			i18nCaptions = new HashMap<>();
		}
		i18nCaptions.putAll(map);
	}
	
	public void addI18nCaption(String locale, String caption) {
		if(i18nCaptions == null) {
			i18nCaptions = new HashMap<>();
		}
		i18nCaptions.put(locale, caption);
	}
	
	public void setCaption(String caption){
		this.caption = caption;
	}
	
	@Deprecated
	public String getCaption(){
		return this.caption;
	}
	
	public String getCaption(String locale) {
		if(i18nCaptions == null || i18nCaptions.isEmpty()) {
			return getCaption();
		}
		String s = i18nCaptions.getOrDefault(locale, "");
		return s;
	}
	
	/**
	 * 字典根據displaycolumn设置显示code或useCode
	 * @param s
	 */
	public void setShowCode(String s) {
		this.showCode = s;
	}
	
	public String getShowCode() {
		return this.showCode;
	}
	
	public void setEnable(int enable){
		this.enable = enable;
	}
	
	public int getEnable(){
		return this.enable;
	}
	
	public void setNodeType(int nodeType){
		this.nodeType = nodeType;
	}
	
	public int getNodeType(){
		return this.nodeType;
	}
	
	
	public void setValue(String colKey , Object value){
		if(colKey.equalsIgnoreCase(SystemField.NODETYPE_DICT_KEY)){
			this.nodeType = TypeConvertor.toInteger(value);
		}else if(colKey.equalsIgnoreCase(SystemField.ENABLE_DICT_KEY)){
			this.enable = TypeConvertor.toInteger(value);
		}
		props.put(colKey, value);
		
	}
	
	public Object getValue(String colKey){
		return props.get(colKey);
	}
	
	public String toString(){
		return getItemKey()+"_"+oid;
	}
	
	public ItemData toItemData(){
		return new ItemData(getItemKey() , oid);
	}
	
	public Set<String> getColKeys(){
		return this.props.keySet();
	}
	
	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject jsonObj = new JSONObject();
		jsonObj.put(DictJSONConstants.ITEMDATA_ITEMKEY, getItemKey());
		jsonObj.put(DictJSONConstants.ITEMDATA_OID, oid);
		jsonObj.put(DictJSONConstants.ITEM_CAPTION, caption);
		jsonObj.put(DictJSONConstants.ITEM_SHOWCODE, showCode);
		
		if(this.i18nCaptions != null && !this.i18nCaptions.isEmpty()) {
			JSONObject i18ns = new JSONObject();
			for(Map.Entry<String, String> entry : i18nCaptions.entrySet()) {
				i18ns.put(entry.getKey(), entry.getValue());
			}
			jsonObj.put(DictJSONConstants.ITEM_I18NCAPTION, i18ns);
		}
		
		for(String key : props.keySet()){
			jsonObj.put(key, props.get(key));
		}
		
		return jsonObj;
	}

	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		oid = JSONHelper.readFromJSON(jsonObj, DictJSONConstants.ITEMDATA_OID, 0l);
		itemKey = JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEMDATA_ITEMKEY,"");
		caption = JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEM_CAPTION,"");
		showCode =JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEM_SHOWCODE,"");
		
		JSONObject i18n = jsonObj.optJSONObject(DictJSONConstants.ITEM_I18NCAPTION);
		if(i18n != null) {
			for(String lang : i18n.keySet()) {
				String v = i18n.optString(lang);
				if(v != null && !v.isEmpty()) {
					this.i18nCaptions.put(lang, v);
				}
			}
		}
		
		props = new HashMap<String,Object>();
		Iterator<?> keys = jsonObj.keys();
		String key;
		while (keys.hasNext()) {
			key = TypeConvertor.toString(keys.next());
			if(key.equals(DictJSONConstants.ITEM_I18NCAPTION)
					|| key.equals(DictJSONConstants.ITEM_SHOWCODE)) {
				continue;
			}
			if(key.equalsIgnoreCase(SystemField.NODETYPE_DICT_KEY)){
				this.nodeType = TypeConvertor.toInteger(jsonObj.get(key));
			}else if(key.equalsIgnoreCase(SystemField.ENABLE_DICT_KEY)){
				this.enable = TypeConvertor.toInteger(jsonObj.get(key));
			}
			props.put(key, jsonObj.get(key));
		}
	}

}
