package com.bokesoft.yigo.struct.condition;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.struct.condition.ConditionJSONConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.exception.StructException;

public class TranformConditionItem implements JSONSerializable, IConditionItem {

	/** 查询字段组建的key */
    private String key = "";
	/** 查询字段类型 */
    private int type = -1;
	/** 日期控件是否不带有时间 */
    private boolean onlyDate = true;
	/** 查询的值 */
    private Object value = "";

	/** 字典itemKey 复合字典做查询条件时用*/
    private String itemKey = "";
	/** 字典状态过滤条件*/
    private int stateMask = DictStateMask.All;

    /** 精度 */
    private int precision = 0;
    /** 小数位数 */
    private int scale = 0;

    /** 是否整形 用于下拉框 */
    private boolean integerValue = false;

    private JSONObject filter = null;

    public TranformConditionItem() {
    }

    public TranformConditionItem(JSONObject jsonObj)
            throws SerializationException, JSONException {
        try {
            fromJSON(jsonObj);
        } catch (StructException e) {
            throw new RuntimeException("conditionItem JSON 转化失败。");
        }
    }

    /**
     * 转换为json对象
     *
     * @return json对象
     */
    public JSONObject toJSON() throws StructException, JSONException {
        JSONObject jsonObj = new JSONObject();

        jsonObj.put(ConditionJSONConstants.COND_KEY, key);
        JSONHelper.writeToJSON(jsonObj, ConditionJSONConstants.COND_TYPE, type,
                -1);
        jsonObj.put(ConditionJSONConstants.COND_VALUE, value2Json(type, value));
        jsonObj.put(ConditionJSONConstants.COND_ONLYDATE, onlyDate);
        jsonObj.put(ConditionJSONConstants.COND_ITEMKEY, itemKey);
        JSONHelper.writeToJSON(jsonObj, ConditionJSONConstants.COND_STATEMASK, stateMask, DictStateMask.All);
        jsonObj.put(ConditionJSONConstants.COND_FILTER, filter);
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
        key = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.COND_KEY, "");
        type = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.COND_TYPE, -1);
        precision = JSONHelper.readFromJSON(jsonObj, "precision", 0);
        scale = JSONHelper.readFromJSON(jsonObj, "scale", 0);
        integerValue = JSONHelper.readFromJSON(jsonObj, "integerValue", false);
        value = json2Value(type, jsonObj.opt(ConditionJSONConstants.COND_VALUE));
        onlyDate = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.COND_ONLYDATE, true);
        itemKey = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.COND_ITEMKEY, "");
        stateMask = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.COND_STATEMASK, DictStateMask.All);
        filter = jsonObj.optJSONObject(ConditionJSONConstants.COND_FILTER);
    }

    private Object value2Json(int controlType, Object value)
            throws SerializationException, JSONException {
        if (value == null) {
            return value;
        }
        Object ret = null;
        switch (controlType) {
            case ControlType.DATEPICKER:
                ret = TypeConvertor.toDate(value).getTime();
                break;
            case ControlType.DICT:
            case ControlType.COMPDICT:
            case ControlType.DYNAMICDICT:
                if (value instanceof ItemData) {
                    ret = ((ItemData) value).toJSON();
                } else if (value instanceof List<?>) {
                    JSONArray jsonArray = new JSONArray();
                    @SuppressWarnings("unchecked")
                    List<ItemData> list = (List<ItemData>) value;
                    for (ItemData itemData : list) {
                        jsonArray.put(itemData.toJSON());
                    }
                    ret = jsonArray;
                }
                break;
            default:
                ret = value;
        }
        return ret;
    }

    private Object json2Value(int controlType, Object value)
            throws StructException, JSONException {
        Object ret = null;
        switch (controlType) {
            case ControlType.DATEPICKER:
                ret = new Date(TypeConvertor.toLong(value));
                break;
            case ControlType.DICT:
            case ControlType.COMPDICT:
            case ControlType.DYNAMICDICT:
                if (value instanceof JSONArray) {
                    List<ItemData> list = new ArrayList<ItemData>();
                    JSONArray jsonArray = (JSONArray) value;
                    JSONObject itemObj;

                    for (int i = 0; i < jsonArray.length(); i++) {
                        itemObj = jsonArray.getJSONObject(i);
                        list.add(new ItemData(itemObj));
                    }
                    ret = list;

                } else if (value instanceof JSONObject) {
                    ret = new ItemData((JSONObject) value);
                }

                break;
            case ControlType.NUMBEREDITOR:
                if (scale == 0) {
                    if (precision <= 9) {
                        ret = TypeConvertor.toInteger(value);
                    } else {
                        ret = TypeConvertor.toLong(value);
                    }
                } else {
                    ret = TypeConvertor.toBigDecimal(value, scale);
                }
                break;
            case ControlType.COMBOBOX:
                if (integerValue) {
                    ret = TypeConvertor.toInteger(value);
                    break;
                }
            default:
                ret = value;
        }
        return ret;
    }

    protected void cloneValue(TranformConditionItem item) {
        item.setKey(key);
        item.setOnlyDate(onlyDate);
        item.setType(type);
        item.setValue(value);
        item.setItemKey(itemKey);
        item.setStateMask(stateMask);
        item.setFilter(filter);
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isOnlyDate() {
        return onlyDate;
    }

    public void setOnlyDate(boolean onlyDate) {
        this.onlyDate = onlyDate;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public void setItemKey(String itemKey) {
        this.itemKey = itemKey;
    }

    public int getStateMask() {
        return this.stateMask;
    }

    public void setStateMask(int stateMask) {
        this.stateMask = stateMask;
    }

    public JSONObject getFilter() {
        return this.filter;
    }

    public void setFilter(JSONObject filter) {
        this.filter = filter;
    }

}
