/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.struct.dict;

import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ItemTableMetaData {
    private int tableMode;
    private String tableName;
    private String key;
    private Map<String, String> cols = new LinkedHashMap<String, String>();
    private String strSortColumns;
    private List<String> sortColumns = null;
    private List<String> i18nColKeys = null;
    private boolean hasCached = false;
    private String clusterID = null;

    public ItemTableMetaData(MetaTable table, boolean isMainTable) {
        MetaColumn clusterIDCol;
        this.tableMode = table.getTableMode();
        this.tableName = table.getBindingDBTableName();
        this.key = table.getKey();
        Iterator it = table.iterator();
        MetaColumn column = null;
        this.i18nColKeys = new ArrayList<String>();
        this.sortColumns = new ArrayList<String>();
        StringBuffer sbSort = new StringBuffer();
        while (it.hasNext()) {
            column = (MetaColumn)it.next();
            if (column.isIgnoreQuery().booleanValue()) continue;
            if ((column.getCache().booleanValue() || column.isSupportI18n().booleanValue()) && !this.hasCached) {
                this.hasCached = true;
            }
            if (column.isSupportI18n().booleanValue()) {
                this.i18nColKeys.add(column.getKey());
            }
            String dbColumnName = column.getBindingDBColumnName();
            this.cols.put(column.getKey(), dbColumnName);
            if (column.getSort() == 1) {
                sbSort.append(",");
                sbSort.append(dbColumnName);
                this.sortColumns.add(dbColumnName);
                continue;
            }
            if (column.getSort() != 2) continue;
            sbSort.append(",");
            sbSort.append(dbColumnName);
            sbSort.append(" desc");
            this.sortColumns.add(dbColumnName);
        }
        if (sbSort.length() > 0) {
            this.strSortColumns = sbSort.substring(1);
        }
        if ((clusterIDCol = table.getCLUSTERIDColumn()) != null) {
            this.clusterID = clusterIDCol.getBindingDBColumnName();
        }
    }

    public boolean isNeedCached() {
        return this.hasCached;
    }

    public boolean containsColumnKey(String colKey) {
        return this.cols.containsKey(colKey);
    }

    public String getColumnName(String columnKey) {
        return this.cols.get(columnKey);
    }

    public int getTableMode() {
        return this.tableMode;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getOIDColumnName() {
        return this.cols.get("OID");
    }

    public String getSOIDColumnName() {
        return this.cols.get("SOID");
    }

    public String getEnableColumnName() {
        return this.cols.get("Enable");
    }

    public String getParentIDColumnName() {
        return this.cols.get("ParentID");
    }

    public String getNodeTypeColumnName() {
        return this.cols.get("NodeType");
    }

    public String getTLeftColumnName() {
        return this.cols.get("TLeft");
    }

    public String getTRightColumnName() {
        return this.cols.get("TRight");
    }

    public String getCodeColumnName() {
        return this.cols.get("Code");
    }

    public String getNameColumnName() {
        return this.cols.get("Name");
    }

    public String getClustIDColumnName() {
        return this.clusterID;
    }

    public String getKey() {
        return this.key;
    }

    public Collection<String> getSelectColumnKeys() {
        return this.cols.values();
    }

    public List<String> getSortColumns() {
        return this.sortColumns;
    }

    public String getStrSortColumns() {
        return this.strSortColumns;
    }

    public List<String> getI18nColumns() {
        return this.i18nColKeys;
    }
}

