package com.bokesoft.yigo.struct.variant;

import java.util.Set;

import org.json.JSONObject;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.json.JSONSerializable;
/**
 * 变体对象,后台返回的时候可以设置前台是否缓存
 * 默认值,默认值表达式,必填是不能追加的,只能覆盖
 * 
 * <pre><code>
 * Variant v = new Variant(formKey);	// 新增一个变体对象
 * v.setCache(true);			// 设置缓存
 * 
 * v.setDefaultValue("A","100");	// 设置默认值
 * v.setDefaultFormula("B","G + H");   // 设置计算表达式
 * v.setRequired("C",true);		// 设置可用性
 *  
 * VariantItem item1 = new VariantItem(Variant.override); // 覆盖可用性计算
 * item1.addValue("D<100");
 * item1.addValue("E<100");
 * 
 * VariantItem item2 = new VariantItem(Variant.override); // 覆盖可用性依赖
 * item2.addValue("D");
 * item2.addValue("E");
 * 
 * v.setEnable("F",item1);
 * v.setEnableDep("F",item2);
 * 
 * VariantItem item3 = new VariantItem(Variant.addition); // 追加检查规则
 * item3.addValue("G>100");
 * v.setCheckRule("G",item3);
 * </code></pre>
 * @author 陈瑞
 *
 */
public class Variant implements JSONSerializable {
	private String formKey;
	private JSONObject o;
	private boolean cache = true;
	
	private String defaultValue = MetaConstants.COMMON_DEFAULTVALUE;
	private String defaultFormula = MetaConstants.COMMON_DEFAULTFORMULAVALUE;
	private String formulaDep = MetaConstants.DATABINDING_VALUEDEPENDENCY;
	
	private String enable = MetaConstants.COMMON_ENABLE;
	private String enableDepend = MetaConstants.COMMON_ENABLE_DEPENDENCY;
	
	private String visible = MetaConstants.COMMON_VISIBLE;
	private String visibleDepend = MetaConstants.COMMON_VISIBLE_DEPENDENCY;
	
	private String checkRule = MetaConstants.DATABINDING_CHECKRULE;
	private String checkRuleDep = MetaConstants.DATABINDING_CHECKDEPENDENCY;
	
	private String errorInfo = MetaConstants.CHECKRULE_ERRORINFO;
	private String required = MetaConstants.DATABINDING_REQUIRED;
	
	private String valueChanged = MetaConstants.DATABINDING_VALUECHANGED;
	
	/** 覆盖表达式*/
	public static int override = 1;
	
	/** 追加表达式*/
	public static int addition = 2;
	
	public Variant() {
		this.o = new JSONObject();
	}
	
	public Variant(String formKey) {
		this.formKey = formKey;
		this.o = new JSONObject();
	}
		
	/**
	 * 获取表单标识
	 * @return 表单标识
	 */
	public String getFormKey() {
		return formKey;
	}
	
	/**
	 * 覆盖控件原有默认值
	 * @param key 控件标识
	 * @param value 默认值
	 */
	public void setDefaultValue(String key,String value) {
		this.setImpl(this.defaultValue, key, value);
	}
	
	/**
	 * 获取一个控件默认值
	 * @param key 控件标识
	 * @param defaultValue 默认值
	 * @return 控件默认值
	 */
	public String getDefaultValue(String key, String defaultValue) {
		return this.getImpl(this.defaultValue, key, defaultValue);
	}
	
	/**
	 * 覆盖控件默认值表达式
	 * @param key 控件标识
	 * @param value 默认值表达式
	 */
	public void setDefaultFormula(String key,String value) {
		this.setImpl(defaultFormula, key, value);
	}
	
	/**
	 * 获取一个控件默认值表达式
	 * @param key 控件标识
	 * @param defaultValue 默认值
	 */
	public String getDefaultFormula(String key, String defaultValue) {
		return this.getImpl(defaultFormula, key, defaultValue);
	}
	
	/**
	 * 覆盖控件默认值依赖
	 * @param key 控件标识
	 * @param value 默认值依赖
	 */
	public void setFormulaDep(String key,String value) {
		this.setImpl(formulaDep, key, value);
	}
	
	/**
	 * 获取一个控件默认值依赖
	 * @param key 控件标识
	 * @param defaultValue 默认值依赖
	 */
	public String getFormulaDep(String key, String defaultValue) {
		return this.getImpl(formulaDep, key, defaultValue);
	}

	/**
	 * 设置一个控件可用性变体信息
	 * @param key 控件标识
	 * @param item 变体信息
	 */
	public void setEnable(String key, VariantItem item) {
		this.setImpl(this.enable, key, item);
	}
	
	/**
	 * 获取一个控件可用性变体信息
	 * @param key 控件标识
	 * @return 可用性变体信息
	 */
	public VariantItem getEnable(String key) {
		return this.getImpl(enable, key);
	}
	
	/**
	 * 获取一个控件可用性依赖变体信息
	 * @param key 控件标识
	 * @param item 可用性依赖变体信息
	 */
	public void setEnableDep(String key, VariantItem item) {
		this.setImpl(this.enableDepend, key, item);
	}
	
	/**
	 * 获取控件可用性依赖变体信息
	 * @param key 控件标识
	 * @return 控件可用性依赖变体信息
	 */
	public VariantItem getEnableDep(String key) {
		return this.getImpl(enableDepend, key);
	}
	
	/**
	 * 设置控件可见性变体信息
	 * @param key 控件标识
	 * @param value 可见性变体信息
	 */
	public void setVisible(String key, VariantItem item) {
		this.setImpl(visible, key, item);
	}
	
	/**
	 * 获取控件可见性变体信息
	 * @param key 控件标识
	 * @return 控件可见性变体信息
	 */
	public VariantItem getVisible(String key) {
		return this.getImpl(visible, key);
	}
	
	/**
	 * 设置可见性依赖变体信息
	 * @param key 控件标识
	 * @param item 可见性依赖变体信息
	 */
	public void setVisibleDep(String key,VariantItem item) {
		this.setImpl(visibleDepend, key, item);
	}
		
	/**
	 * 获取可见性依赖变体信息
	 * @param key 控件标识
	 * @return 可见性依赖变体信息
	 */
	public VariantItem getVisibleDep(String key) {
		return this.getImpl(visible, key);
	}
	
	/**
	 * 设置检查规则变体信息
	 * @param key 控件标识
	 * @param item 变体信息
	 */
	public void setCheckRule(String key,VariantItem item) {
		this.setImpl(checkRule, key, item);
	}
		
	/**
	 * 获取检查规则变体信息
	 * @param key 控件标识
	 * @return 检查规则变体信息
	 */
	public VariantItem getCheckRule(String key) {
		return this.getImpl(checkRule, key);
	}
	
	/**
	 * 设置检查规则依赖变体信息
	 * @param key 控件标识
	 * @param item 规则依赖
	 */
	public void setCheckRuleDep(String key,VariantItem item) {
		this.setImpl(checkRuleDep, key, item);
	}
		
	/**
	 * 获取检查规则依赖
	 * @param key 控件标识
	 */
	public VariantItem getCheckRuleDep(String key) {
		return this.getImpl(checkRuleDep, key);
	}
	
	/**
	 * 设置控件必填
	 * @param key 控件标识
	 * @param value 必填
	 */
	public void setRequired(String key, boolean value) {
		this.setImpl(required, key, String.valueOf(value));
	}
	
	/**
	 * 获取控件必填
	 * @param key 控件标识
	 * @param defaultValue 默认值
	 * @return 控件必填
	 */
	public String getRequired(String key, String defaultValue) {
		return this.getImpl(required, key, defaultValue);
	}
	
	/**
	 * 设置控件检查规则错误信息
	 * @param key 控件标识
	 * @param info 错误信息
	 */
	public void setErrorInfo(String key, String info) {
		this.setImpl(errorInfo, key, info);
	}
	
	/**
	 * 获取控件检查规则错误信息
	 * @param key 控件标识
	 * @param defaultValue 默认值
	 * @return 检查规则错误信息
	 */
	public String getErrorInfo(String key, String defaultValue) {
		return this.getImpl(errorInfo, key, defaultValue);
	}
	
	/**
	 * 设置检查规则依赖变体信息
	 * @param key 控件标识
	 * @param item 规则依赖
	 */
	public void setValueChanged(String key,VariantItem item) {
		this.setImpl(this.valueChanged, key, item);
	}
		
	/**
	 * 获取检查规则依赖
	 * @param key 控件标识
	 * @param value 默认值
	 */
	public VariantItem getValueChanged(String key) {
		return this.getImpl(this.valueChanged, key);
	}

	/**
	 * 设置是否前台缓存变体
	 * @param cache 是否缓存
	 */
	public void setCache(boolean cache) {
		this.cache = cache;
	}
	
	/**
	 * 获取是否前台缓存
	 * @return 是否前台缓存
	 */
	public boolean isCache() {
		return cache;
	}
	
	/**
	 * 获取大类
	 * @param field
	 * @return
	 */
	public JSONObject get(String field) {
		return o.optJSONObject(field);
	}
	
	private void setImpl(String field, String key, String value) {
		JSONObject o1 = o.optJSONObject(field);
		if( o1 == null ) {
			o1 = new JSONObject(); // 大类
			o.put(field, o1);
		}
		VariantItem item = (VariantItem) o1.opt(key);
		if( item == null ) {
			item = new VariantItem(override); // 具体控件
			o1.put(key, item);
		}
		if( item.size() == 0 ) {
			item.addValue(value);
		} else {
			item.setValue(0, value);					
		}
	}
	
	private void setImpl(String field, String key, VariantItem item) {
		JSONObject o1 = o.optJSONObject(field);
		if( o1 == null ) {
			o1 = new JSONObject();
			o.put(field, o1);
		}
		o1.put(key, item);	
	}
	
	private String getImpl(String field, String key, String defaultValue) {
		JSONObject o1 = o.optJSONObject(field); // 获取大类
		if( o1 == null ) {
			return defaultValue;
		}
		VariantItem item = (VariantItem) o1.opt(key); // 获取控件
		if( item == null ) {
			return defaultValue;
		}
		return item.size() > 0 ? item.getValue(0) : defaultValue;
	}
	
	private VariantItem getImpl(String field, String key) {
		JSONObject o1 = o.optJSONObject(field); // 获取大类
		if( o1 == null ) {
			return null;
		}
		return (VariantItem) o1.opt(key); // 获取控件
	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject o = new JSONObject();
		o.put("formKey", formKey);
		o.put("cache", cache);
		
		JSONObject data = new JSONObject();
				
		VariantItem item = null;
		JSONObject json = null;
		JSONObject o1 = null;
		Set<String> set = this.o.keySet();
		for( String key : set ) {
			json = this.o.optJSONObject(key);
			o1 = new JSONObject();
			Set<String> set1 = json.keySet();
			for( String key1 : set1 ) {
				item = (VariantItem) json.opt(key1);
				o1.put(key1, item.toJSON());
			}
			data.put(key, o1);
		}
		o.put("data", data);
		return o;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void fromJSON(JSONObject o) throws Throwable {
		this.formKey = o.getString("formKey");
		this.cache = o.optBoolean("cache");
			
		JSONObject json = null;
		JSONObject o1 = null;
		
		JSONObject data = o.optJSONObject("data");
		
		Set<String> set = data.keySet();
		for( String key : set ) {
			json = data.optJSONObject(key);
			o1 = new JSONObject();
			Set<String> set1 = json.keySet();
			for( String key1 : set1 ) {
				o1.put(key1, new VariantItem(json.optJSONObject(key1)));
			}
			this.o.put(key, o1);
		}
	}
}
