package com.bokesoft.yigo.struct.util;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.UUID;

import com.bokesoft.yes.common.util.StringUtil;

public class EnvUtil {

	public final static String createTempClientID() {
		String mac = getMAC();
		if (StringUtil.isBlankOrNull(mac)) {
			UUID uuid = UUID.randomUUID();
			return uuid.toString();
		} else {
			return mac;
		}
	}

	private static String hexByte(byte b) {
		String s = "000000" + Integer.toHexString(b);
		return s.substring(s.length() - 2);
	}

	public static String getMAC() {
		Enumeration<NetworkInterface> el;
		String mac_s = "";
		try {
			el = NetworkInterface.getNetworkInterfaces();
			while (el.hasMoreElements()) {
				byte[] mac = el.nextElement().getHardwareAddress();
				if (mac == null)
					continue;
				mac_s = hexByte(mac[0]) + "-" + hexByte(mac[1]) + "-"
						+ hexByte(mac[2]) + "-" + hexByte(mac[3]) + "-"
						+ hexByte(mac[4]) + "-" + hexByte(mac[5]);
			}
		} catch (SocketException e1) {
			e1.printStackTrace();
		}
		return mac_s;
	}
	
	public static String getFingerprintKey(String metaKey, String cmdKey, long userid) {
		StringBuilder sb = new StringBuilder();
		sb.append(metaKey).append("|").append(cmdKey).append("|").append(userid);
		return sb.toString();
	}

}
