package com.bokesoft.yigo.struct.state;

import org.json.JSONObject;

import com.bokesoft.yigo.common.json.JSONSerializable;

/**
 * SetComponentState定义集合控件的状态
 * @author wangyh
 *
 */
public class SetComponentState implements JSONSerializable {
	/** 控件标识 */
	private String key = "";
	/** 当前行 */
	private int curRow = -1;
	
	/**
	 * 设置控件标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得控件标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置当前行
	 * @param curRow 当前行
	 */
	public void setCurRow(int curRow) {
		this.curRow = curRow;
	}
	
	/**
	 * 取得当前行
	 * @return 当前行
	 */
	public int getCurRow() {
		return this.curRow;
	}

	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject json = new JSONObject();
		json.put("key", key);
		json.put("curRow", curRow);
		return json;
	}

	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		key = jsonObj.optString("key");
		curRow = jsonObj.optInt("curRow");
	}
}
