package com.bokesoft.yigo.struct.i18n;

import java.util.HashMap;

/**
 * I18NInfo相关集合对象
 */
public class I18NInfoMap {

    public static final String MapType_TranslationType = "TranslationType";
    public static final String MapType_Solution = "Solution";
    public static final String MapType_Project = "Project";
    public static final String MapType_Form = "Form";
    public static final String MapType_Lang = "Lang";

    /**
     * 当前集合类型，分为TranslationType，Solution，Project，Form，Lang
     */
    private String mapType = null;
    /**
     * 根据MapType值，设置值，值为TranslationType的具体值，Solution的Key值，Project的Key值，Form的Key值，Lang的值
     */
    private String key = null;
    /**
     * 存在的内部子项集合的集合
     */
    private final HashMap<String, I18NInfoMap> childMap = new HashMap<>();
    /**
     * 存在的内部数据行对象集合
     */
    private final HashMap<String, I18NInfoItem> itemMap = new HashMap<>();

    /**
     * 设置集合类型
     *
     * @param mapType 集合类型
     */
    public void setMapType(String mapType) {
        this.mapType = mapType;
    }

    /**
     * 获取集合类型
     *
     * @return 集合类型
     */
    public String getMapType() {
        return mapType;
    }

    /**
     * 设置集合标识，根据MapType的值，该值设置为TranslationType的具体值，Solution的Key值，Project的Key值，Form的Key值
     *
     * @param key 集合标识
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * 获取集合标识
     *
     * @return 集合标识
     */
    public String getKey() {
        return key;
    }

    /**
     * 获取内部存在的子集合对象集合
     *
     * @return 子集合对象集合
     */
    public HashMap<String, I18NInfoMap> getChildMap() {
        return childMap;
    }

    /**
     * 获取内部存在的数据行对象集合
     *
     * @return 数据行对象集合
     */
    public HashMap<String, I18NInfoItem> getItemMap() {
        return itemMap;
    }

    /**
     * 添加子集合对象
     *
     * @param key      子集合对象的标识
     * @param childMap 子集合对象
     */
    public void putChildByKey(String key, I18NInfoMap childMap) {
        this.childMap.put(key, childMap);
    }

    /**
     * 获取子集合对象
     *
     * @param key 子集合对象的标识
     * @return 子集合对象
     */
    public I18NInfoMap getChildByKey(String key) {
        return childMap.get(key);
    }

    /**
     * 添加数据行对象
     *
     * @param key  数据行对象的标识
     * @param item 数据行对象
     */
    public void putItemByKey(String key, I18NInfoItem item) {
        this.itemMap.put(key, item);
    }

    /**
     * 获取数据行对象
     *
     * @param key 数据行对象的标识
     * @return 数据行对象
     */
    public I18NInfoItem getItemByKey(String key) {
        return itemMap.get(key);
    }

    /**
     * 删除数据行对象的标识
     * @param key 数据行对象的标识
     */
    public void removeItem(String key) {
        itemMap.remove(key);
    }
}
