package com.bokesoft.yigo.struct.condition;

/**
 * IConditionParaTable为拼接条件时的参数表，用于取得拼接条件可用的每个参数的值
 * @author wangyh
 *
 */
public interface IConditionParaTable {
	/**
	 * 判断指定参数是否存在
	 * @param key 参数的标识
	 * @return 如果key表示的参数存在则返回true，否则返回false
	 */
	public boolean contains(String key);
	
	/**
	 * 取得指定参数的值
	 * @param key 参数的标识
	 * @return 如果key表示的参数存在则返回其值，否则返回null
	 */
	public Object getValue(String key);
}
