/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.data.table;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.StatusUtil;
import com.bokesoft.yes.bpm.engine.data.OIDRef;
import com.bokesoft.yes.bpm.engine.data.row.RTransaction;
import com.bokesoft.yes.bpm.engine.data.table.BPMTable;
import com.bokesoft.yes.bpm.engine.util.ProcessUtil;
import com.bokesoft.yes.bpm.workitem.data.SqlHelper;
import com.bokesoft.yes.mid.cache.RowKey;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.mid.connection.IDBManager;

public class TTransaction
extends BPMTable<RTransaction> {
    public TTransaction(Long l2, OIDRef oIDRef) {
        super(l2, oIDRef);
    }

    @Override
    public String getDataSourceSql(IDBManager iDBManager) {
        return "select * from  " + iDBManager.keyWordEscape("BPM_Transaction") + " where " + iDBManager.keyWordEscape("InstanceID") + "=? order by " + iDBManager.keyWordEscape("TransactionID") + " desc";
    }

    @Override
    public String getDeleteSql(IDBManager iDBManager) {
        return "delete from " + iDBManager.keyWordEscape("BPM_Transaction") + " where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("TransactionID") + "=?";
    }

    @Override
    public String getInsertSql(IDBManager iDBManager) {
        return "insert into  " + iDBManager.keyWordEscape("BPM_Transaction") + "  (" + iDBManager.keyWordEscape("InstanceID") + "," + iDBManager.keyWordEscape("OID") + "," + iDBManager.keyWordEscape("WorkitemID") + "," + iDBManager.keyWordEscape("TransactionID") + "," + iDBManager.keyWordEscape("OperatorID") + "," + iDBManager.keyWordEscape("WorkitemRevoke") + "," + iDBManager.keyWordEscape("fieldKey") + "," + iDBManager.keyWordEscape("fieldValue") + "," + iDBManager.keyWordEscape("statusValue") + ") values(?,?,?,?,?,?,?,?,?)";
    }

    @Override
    protected String getDeleteAllSql(IDBManager iDBManager) {
        return "delete from " + iDBManager.keyWordEscape("BPM_Transaction") + "  where " + iDBManager.keyWordEscape("InstanceID") + "=?";
    }

    @Override
    public RTransaction createEmptyRow() {
        return new RTransaction(this.instanceID);
    }

    public QueryArguments getDeletePSArgs(IDBManager iDBManager, RTransaction rTransaction) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        SqlHelper.dealInstanceID2ConditionArge(iDBManager, this.instanceID, this.OID, pSArgs);
        pSArgs.addIntArg(rTransaction.getTransactionID());
        return pSArgs;
    }

    public QueryArguments getUpdatePSArgs(IDBManager iDBManager, RTransaction rTransaction) throws Throwable {
        return null;
    }

    @Override
    public QueryArguments getInsertPSArgs(RTransaction rTransaction) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        pSArgs.addLongArg(this.instanceID);
        pSArgs.addLongArg(Long.valueOf(this.OID.get()));
        pSArgs.addLongArg(rTransaction.getWorkitemID());
        pSArgs.addIntArg(rTransaction.getTransactionID());
        pSArgs.addLongArg(rTransaction.getOperatorID());
        pSArgs.addIntArg(Integer.valueOf(rTransaction.isworkitemRevoke() ? 1 : 0));
        pSArgs.addStringArg(rTransaction.getFieldKey());
        pSArgs.addStringArg(rTransaction.getFieldValue());
        pSArgs.addIntArg(rTransaction.getStatusValue());
        return pSArgs;
    }

    public Integer getTransactionIDByWorkitemID(Long l2, IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        for (RTransaction rTransaction : this.rowList) {
            if (!rTransaction.getWorkitemID().equals(l2)) continue;
            return rTransaction.getTransactionID();
        }
        return -1;
    }

    public int rollbackToWorkitem(BPMContext bPMContext, Long object, Boolean object22, IDBManager iDBManager) throws Throwable {
        this.load(iDBManager);
        int n2 = -1;
        Integer.valueOf(-1);
        Integer n3 = null;
        for (RTransaction rTransaction : this.rowList) {
            if (!rTransaction.getWorkitemID().equals(object) || rTransaction.getTransactionID() < 0) continue;
            n2 = rTransaction.getTransactionID();
            n3 = rTransaction.getStatusValue();
            break;
        }
        if (n2 < 0) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)17, (Object[])new Object[0]);
        }
        for (RTransaction rTransaction : this.rowList) {
            if (rTransaction.getTransactionID() < n2) continue;
            StatusUtil.changeFieldValue(bPMContext, rTransaction.getFieldKey(), rTransaction.getFieldValue());
        }
        if (n3 >= 0) {
            StatusUtil.changeStatusValue(bPMContext, n3);
        }
        if (!object22.booleanValue()) {
            return n2;
        }
        long l2 = bPMContext.getEnv().getUserID();
        for (Object object22 : this.rowList) {
            if (((RTransaction)((Object)object22)).getTransactionID() < n2 || ((RTransaction)((Object)object22)).isworkitemRevoke() && (((RTransaction)((Object)object22)).getOperatorID() == l2 || ProcessUtil.isProcessAdministrator(bPMContext, l2, bPMContext.getProcesskey(), bPMContext.getVerID()))) continue;
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)17, (Object[])new Object[0]);
        }
        return n2;
    }

    public Integer getStatusByWorkitemID(Long l2, IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        for (RTransaction rTransaction : this.rowList) {
            if (!rTransaction.getWorkitemID().equals(l2)) continue;
            return rTransaction.getStatusValue();
        }
        return -1;
    }

    public void deleteData(int n2, IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        for (RTransaction rTransaction : this.rowList) {
            if (rTransaction.getTransactionID() < n2) continue;
            rTransaction.setDeleted();
        }
    }

    public RTransaction getTransaction(int n2, IDBManager iDBManager) throws Throwable {
        RowKey rowKey = new RowKey();
        rowKey.put((Object)this.instanceID);
        rowKey.put((Object)n2);
        RTransaction rTransaction = (RTransaction)this.getRow(rowKey);
        if (rTransaction == null) {
            this.load(iDBManager);
            rTransaction = (RTransaction)this.getRow(rowKey);
        }
        return rTransaction;
    }
}

