package com.bokesoft.yigo.bpm.monitor;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bokesoft.yes.log.base.BaseInfo;
import com.bokesoft.yes.log.base.ISaveSvr;
import com.bokesoft.yes.log.base.SaveSvr;
public class LoggerManager {
	private static List<LogData> LOGS = new ArrayList<LogData>();
	/**
	 * 添加日志数据
	 * @param data
	 */
	public static void addLogData(LogData data) {
		LOGS.add(data);
	}
	/**
	 * 将日志数据刷新到日志文件中
	 */
	public static void flush() throws Throwable{
		if (LOGS.size() == 0) {
			return ;
		}
		
		for (LogData logData : LOGS) {
			String logStr = logData.toJSON().toString();
			//将数据提交到log4j中
			//logger.info(logStr);
			
			// 读取base.conf文件
			BaseInfo info = new BaseInfo();
			info.loadproperties();
			
			ISaveSvr ils = SaveSvr.getInstance();
			ils.chooseType(info.getsendType());
			ils.start(info.getAgentName());
			ils.send(info.getLevel(), logStr);	
		}
		
		LOGS.clear();
	}
	
	private static Logger logger =  LoggerFactory.getLogger("com.bokesoft.yes.bpm.mid");
	
}
