package com.bokesoft.yigo.bpm.message;

import org.json.JSONObject;

import com.bokesoft.yigo.common.json.JSONSerializable;

public class BasicInfo implements JSONSerializable {
	
	private long instanceID = -1l;
	private int inlineNodeID = -1;
	
	// 消息的发送节点（sourceNodeID）与接受节点（targetNodeID）
	private int sourceNodeID = -1;
	private int targetNodeID = -1;
	
	public long getInstanceID() {
		return instanceID;
	}

	public void setInstanceID(long instanceID) {
		this.instanceID = instanceID;
	}

	public int getInlineNodeID() {
		return inlineNodeID;
	}

	public void setInlineNodeID(int inlineNodeID) {
		this.inlineNodeID = inlineNodeID;
	}

	public int getSourceNodeID() {
		return sourceNodeID;
	}

	public void setSourceNodeID(int sourceNodeID) {
		this.sourceNodeID = sourceNodeID;
	}

	public int getTargetNodeID() {
		return targetNodeID;
	}

	public void setTargetNodeID(int targetNodeID) {
		this.targetNodeID = targetNodeID;
	}

	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject json = new JSONObject();
		json.put("instanceID", instanceID);
		json.put("inlineNodeID", inlineNodeID);
		json.put("sourceNodeID", sourceNodeID);
		json.put("targetNodeID", targetNodeID);
		return json;
	}

	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		instanceID = jsonObj.optLong("instanceID", -1l);
		inlineNodeID = jsonObj.optInt("inlineNodeID", -1);
		sourceNodeID = jsonObj.optInt("sourceNodeID", -1);
		targetNodeID = jsonObj.optInt("targetNodeID", -1);
	}

}
