package com.bokesoft.yigo.bpm.dev;
/**
 * 流程继续流转
 * @author wbh
 *
 */

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yigo.bpm.common.BPMContext;

public class WorkflowResume {
	/** 执行上下文*/
	private BPMContext context = null;
	/** 当前节点*/
	private ExecNode node = null;
	
	/**
	 * 构造函数：需保证上下文正确
	 * @param context 上下文
	 * @param nodeID 需要继续流转的节点ID
	 * @param inlineNodeID 嵌入节点ID，若不存在嵌入节点，则应赋值为-1
	 */
	public WorkflowResume(BPMContext context, int nodeID, int inlineNodeID) {
		this.context = context;
		BPMInstance instance = context.getActiveBPMInstance();
		node = instance.getNodeByID(inlineNodeID, nodeID);
	}
	
	/**
	 * 流程继续流转
	 */
	public void resume() throws Throwable{
		if (node != null) {
			node.resume(context);
		}
	}
}
