package com.bokesoft.yigo.bpm;

import java.util.List;

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.meta.transform.PPObject;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemState;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;

/**
 * 将任务转交给多个人，只要有一个人完成，该任务即完成<br>
 * 若转交给一个人，请参考 {@link TransferTask}<br>
 * 转交的多个人中可以包含原参与者<br>
 * 可以设置是否创建新的工作项，由属性createRecord决定，默认为false，若为true，则原工作项自动完成，同时新创建的工作项会创建新的超时任务<br>
 * 目前仅支持用户任务或审批任务执行该操作
 * 
 * @author wbh
 *
 */
public class BatchTransferTask {
	
	/** 当前工作项ID*/
	private Long workitemID = -1L;
	/** 参与者集合*/
	private PPObject ppObject = null;
	/** 是否创建新的工作项*/
	private boolean createRecord = false;
	/** 用户意见*/
	private String userinfo = "";
	/** 审批结果*/
	private int auditResult = -1;
	/** 原操作员*/
	private long srcOperator = 0l;
	/** 转交类型*/
	private int transferType = -1;
	
	/**
	 * 构造函数
	 * @param workitemID 工作项ID
	 * @param optList 参与者集合
	 */
	public BatchTransferTask(long workitemID, List<Long> optList) {
		this.workitemID = workitemID;
		ppObject = new PPObject(optList);
	}
	
	/**
	 * 构造函数
	 * @param workitemID 工作项ID
	 * @param optList 参与者集合
	 * @param createRecord 是否创建新的工作项，true:是, false:保持原工作项
	 * @param userInfo 用户意见
	 * @param auditResult 审批结果
	 * @param srcOpt 原操作员
	 * @param transferType 转交类型
	 */
	public BatchTransferTask(long workitemID, List<Long> optList, boolean createRecord, String userInfo
			,int auditResult, long srcOpt, int transferType) {
		this.workitemID = workitemID;
		ppObject = new PPObject(optList);
		this.createRecord = createRecord;
		this.userinfo = userInfo;
		this.auditResult = auditResult;
		this.srcOperator = srcOpt;
		this.transferType = transferType;
	}
	/**
	 * 执行转交
	 * @param context
	 * @throws Throwable
	 */
	public void transfer(BPMContext context)throws Throwable {
		
		Workitem workitem = WorkitemUtil.loadWorkitem(context, workitemID);
		if (workitem == null)
			return;
		context = BPMContext.getBPMContext(context, workitem.getInstanceID());
		context.setUpdateWorkitem(workitem);
		if (createRecord) {
			workitem.setWorkItemState(WorkitemState.FINISH);
			workitem.setAuditResult(auditResult);
			workitem.setUserInfo(userinfo);
		} else {
			workitem.setWorkItemState(WorkitemState.NEW);
		}
		workitem.setTransferType(transferType);
		
		BPMInstance instance = BPMInstanceFactory.getBPMInstance(context, workitem.getInstanceID());
		if (instance != null) {
			context.setSrcOperator(srcOperator);
			ExecNode node = instance.getNodeByID(workitem.getInlineNodeID(), workitem.getNodeID());
			node.batchTransferTask(context, ppObject, createRecord);
		}
		context.getInstanceDataContainer().save();
	}
	
	public boolean isCreateRecord() {
		return createRecord;
	}
	public void setCreateRecord(boolean createRecord) {
		this.createRecord = createRecord;
	}
	public String getUserinfo() {
		return userinfo;
	}
	public void setUserinfo(String userinfo) {
		this.userinfo = userinfo;
	}
	public int getAuditResult() {
		return auditResult;
	}
	public void setAuditResult(int auditResult) {
		this.auditResult = auditResult;
	}
	public long getSrcOperator() {
		return srcOperator;
	}
	public void setSrcOperator(long srcOperator) {
		this.srcOperator = srcOperator;
	}
	public int getTransferType() {
		return transferType;
	}
	public void setTransferType(int transferType) {
		this.transferType = transferType;
	}
	
	
}
