/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.bpm.common;

import com.bokesoft.yes.bpm.engine.common.Result;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.meta.transform.WorkitemInfo;
import com.bokesoft.yes.bpm.workitem.TransitData;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.mid.base.DefaultMidVEFactory;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import org.json.JSONObject;

public class MessageUtil {
    private static final String INSTANCEID = "instanceID";
    private static final String NODEID = "nodeID";
    private static final String INLINENODEID = "inlineNodeID";
    private static final String WORKITEM_INFO = "workitemInfo";
    private static final String ADDITIONALINFO = "additionalInfo";
    private static final String OPERATIONTYPE = "operationType";
    private static final String ACTIVE_TOKENID = "activeTokenID";
    private static final String NEW_WORKITEM_ID = "newWorkitemID";
    private static final String ACTIVE_PARTICIPATOR = "activeParticipator";
    private static final String DEFAULT_CHECK = "defaultCheck";
    private static final String UPDATE_CHECKER_FIELD = "updateCheckerField";
    private static final String TRANSITDATA = "transitData";
    private static final String WORKITEMID = "workitemID";
    private static final String KEEPPARTS = "keepParts";

    public static JSONObject getDefaultTokenInfo(BPMContext bPMContext, MetaNode metaNode) throws Throwable {
        JSONObject jSONObject = new JSONObject();
        long l2 = -1L;
        BPMInstance bPMInstance = bPMContext.getActiveBPMInstance();
        if (bPMInstance != null) {
            l2 = bPMInstance.getInstanceID();
        }
        jSONObject.put(INSTANCEID, l2);
        int n2 = metaNode.getID();
        jSONObject.put(NODEID, n2);
        jSONObject.put(INLINENODEID, -1);
        WorkitemInfo workitemInfo = MessageUtil.getWorkitemInfo(bPMContext);
        if (workitemInfo != null) {
            jSONObject.put(WORKITEM_INFO, (Object)workitemInfo.toJSON());
        }
        bPMContext = MessageUtil.getAdditionInfo(bPMContext);
        jSONObject.put(ADDITIONALINFO, (Object)bPMContext);
        return jSONObject;
    }

    public static BPMContext getContextFromTokenInfo(JSONObject jSONObject) throws Throwable {
        Object object = new DefaultMidVEFactory();
        object = new BPMContext(object.createVE());
        long l2 = -1L;
        int n2 = -1;
        if (jSONObject.has(INSTANCEID)) {
            l2 = jSONObject.getLong(INSTANCEID);
        }
        if (jSONObject.has(NODEID)) {
            n2 = jSONObject.getInt(NODEID);
        }
        if (l2 == -1L || n2 == -1) {
            return null;
        }
        if (BPMInstanceFactory.getBPMInstance((BPMContext)((Object)(object = BPMContext.getBPMContext((BPMContext)((Object)object), (Long)l2))), l2) == null) {
            return null;
        }
        if (jSONObject.has(WORKITEM_INFO)) {
            WorkitemInfo workitemInfo = new WorkitemInfo();
            workitemInfo.fromJSON(jSONObject.getJSONObject(WORKITEM_INFO));
            MessageUtil.recoverWorkitemInfo((BPMContext)((Object)object), workitemInfo);
        }
        if (jSONObject.has(ADDITIONALINFO)) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(ADDITIONALINFO);
            MessageUtil.recoverAdditionInfo((BPMContext)((Object)object), jSONObject2);
        }
        return object;
    }

    private static WorkitemInfo getWorkitemInfo(BPMContext bPMContext) {
        Workitem workitem = bPMContext.getUpdateWorkitem();
        if (workitem == null) {
            return null;
        }
        WorkitemInfo workitemInfo = new WorkitemInfo();
        workitemInfo.setWorkitemID(workitem.getWorkItemID());
        workitemInfo.setAuditResult(Integer.valueOf(workitem.getAuditResult()));
        workitemInfo.setUserInfo(workitem.getUserInfo());
        workitemInfo.setOperationKey(workitem.getOperationKey());
        workitemInfo.setNextOpStr(workitem.getNextOpStr());
        workitemInfo.setSrcOperator(bPMContext.getSrcOperator());
        if (bPMContext.getBackSite() != null && bPMContext.getBackSite().length() > 0) {
            workitemInfo.setBackSite(bPMContext.getBackSite());
            workitemInfo.setBackSiteOpt(Long.valueOf(bPMContext.getBackSiteOpt()));
        }
        return workitemInfo;
    }

    private static void recoverWorkitemInfo(BPMContext bPMContext, WorkitemInfo workitemInfo) throws Throwable {
        Workitem workitem = WorkitemUtil.loadWorkitem(bPMContext, workitemInfo.getWorkitemID());
        if (workitem == null) {
            return;
        }
        workitem.setAuditResult(workitemInfo.getAuditResult());
        workitem.setUserInfo(workitemInfo.getUserInfo());
        workitem.setResultInfo(Result.parseToString(workitemInfo.getAuditResult()));
        workitem.setOperationKey(workitemInfo.getOperationKey());
        workitem.setNextOpStr(workitemInfo.getNextOpStr());
        bPMContext.setSrcOperator(workitemInfo.getSrcOperator());
        if (workitemInfo.getBackSite() != null && workitemInfo.getBackSite().length() > 0) {
            bPMContext.setBackSite(workitemInfo.getBackSite());
            bPMContext.setTransitTo(workitem.getNodeID());
            bPMContext.setBackSiteWorkitemID(workitemInfo.getWorkitemID());
            bPMContext.setBackSiteOpt(workitemInfo.getBackSiteOpt());
        }
        bPMContext.setUpdateWorkitem(workitem);
    }

    private static JSONObject getAdditionInfo(BPMContext object) throws Throwable {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(OPERATIONTYPE, ((BPMContext)((Object)object)).getOperationType());
        jSONObject.put(ACTIVE_TOKENID, ((BPMContext)((Object)object)).getActiveTokenID());
        jSONObject.put(NEW_WORKITEM_ID, (Object)((BPMContext)((Object)object)).getNewWorkitemID());
        jSONObject.put(ACTIVE_PARTICIPATOR, (Object)((BPMContext)((Object)object)).getActiveParticipator());
        jSONObject.put(UPDATE_CHECKER_FIELD, ((BPMContext)((Object)object)).updateCheckerField());
        object = ((BPMContext)((Object)object)).getTransitData();
        if (object != null) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put(WORKITEMID, ((TransitData)object).getWorkitemID());
            jSONObject2.put(NODEID, ((TransitData)object).getNodeID());
            jSONObject2.put(KEEPPARTS, ((TransitData)object).keepParts());
            jSONObject.put(TRANSITDATA, (Object)jSONObject2.toString());
        }
        return jSONObject;
    }

    private static void recoverAdditionInfo(BPMContext bPMContext, JSONObject jSONObject) throws Throwable {
        if (jSONObject == null) {
            return;
        }
        if (jSONObject.has(OPERATIONTYPE)) {
            bPMContext.setOperationType(jSONObject.getInt(OPERATIONTYPE));
        }
        if (jSONObject.has(ACTIVE_TOKENID)) {
            bPMContext.setActiveTokenID(jSONObject.getInt(ACTIVE_TOKENID));
        }
        if (jSONObject.has(NEW_WORKITEM_ID)) {
            bPMContext.setNewWorkitemID(jSONObject.getLong(NEW_WORKITEM_ID));
        }
        if (jSONObject.has(ACTIVE_PARTICIPATOR)) {
            bPMContext.setActiveParticipator(jSONObject.getLong(ACTIVE_PARTICIPATOR));
        }
        if (jSONObject.has(UPDATE_CHECKER_FIELD)) {
            bPMContext.setUpdateCheckerField(jSONObject.getBoolean(UPDATE_CHECKER_FIELD));
        }
        if (jSONObject.has(TRANSITDATA)) {
            jSONObject = jSONObject.getJSONObject(TRANSITDATA);
            long l2 = jSONObject.getLong(WORKITEMID);
            int n2 = jSONObject.getInt(NODEID);
            TransitData transitData = new TransitData(n2, l2);
            boolean bl = jSONObject.getBoolean(KEEPPARTS);
            transitData.setKeepParts(bl);
            bPMContext.setTransitData(transitData);
        }
    }
}

