/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.common.Result;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.instance.CreateNodeUtil;
import com.bokesoft.yes.bpm.engine.instance.VirtualInstance;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.util.ProcessUtil;
import com.bokesoft.yes.bpm.meta.transform.ManualTransferInfo;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class ManualTransferToNode {
    private ManualTransferInfo info = new ManualTransferInfo();

    public ManualTransferToNode(long l2, int n2, int n3, String string, boolean bl) {
        this.info.setWorkitemID(l2);
        this.info.setTransferTo(n2);
        this.info.setAuditResult(Integer.valueOf(n3));
        this.info.setUserInfo(string);
        this.info.setLock(bl);
    }

    public ManualTransferToNode(long l2, int n2, int n3, int n4, String string, boolean bl) {
        this.info.setInstanceID(l2);
        this.info.setNodeID(n2);
        this.info.setTransferTo(n3);
        this.info.setAuditResult(Integer.valueOf(n4));
        this.info.setUserInfo(string);
    }

    public void transfer(BPMContext bPMContext) throws Throwable {
        ExecNode execNode;
        if (this.info == null) {
            return;
        }
        long l2 = this.info.getInstanceID();
        long l3 = this.info.getWorkitemID();
        Workitem workitem = null;
        if (l3 > 0L) {
            workitem = this.loadWorkitem(bPMContext, l3);
            l2 = workitem.getInstanceID();
        }
        bPMContext = BPMContext.getBPMContext(bPMContext, (Long)l2);
        bPMContext.setUpdateWorkitem(workitem);
        BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstance(bPMContext, l2);
        if (bPMInstance == null) {
            return;
        }
        MetaProcess metaProcess = BPMUtil.getProcessByInstance(bPMContext, bPMInstance);
        String string = metaProcess.getKey();
        int n2 = metaProcess.getVersion();
        long l4 = this.info.getSrcOperator() > 0L ? this.info.getSrcOperator() : bPMContext.getCurUserID().longValue();
        if (l4 > 0L) {
            bPMContext.setSrcOperator(l4);
        }
        if (l4 != 21L && !ProcessUtil.isProcessAdministrator(bPMContext, l4, string, n2)) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)24, (Object[])new Object[0]);
        }
        int n3 = this.info.getTransferTo();
        n2 = workitem == null ? this.info.getNodeID() : workitem.getNodeID();
        int n4 = workitem == null ? this.info.getInlineNodeID().intValue() : workitem.getInlineNodeID();
        ExecNode execNode2 = bPMInstance.getNodeByID(n4, n2);
        execNode2.manualTransfer(bPMContext, this.info);
        try {
            execNode = bPMInstance.getNodeByID(-1, n3);
        }
        catch (Throwable throwable) {
            execNode = this.createNode(bPMInstance.getMainInstance(), n3, execNode2, bPMContext);
        }
        if (execNode != null) {
            execNode.input(bPMContext);
        }
        if (this.info.isLock()) {
            WorkitemUtil.lockWorkitem(bPMContext, n3, l2, metaProcess);
        }
        bPMContext.getInstanceDataContainer().save();
    }

    private ExecNode createNode(VirtualInstance object, int n2, ExecNode execNode, BPMContext bPMContext) throws Throwable {
        Object object2 = ((VirtualInstance)object).getMetaNodeByID(n2);
        object = new CreateNodeUtil(bPMContext, (VirtualInstance)object);
        object2 = ((CreateNodeUtil)object).createNode((MetaNode)object2);
        ((CreateNodeUtil)object).handleExclusiveFork(execNode, (ExecNode)((Object)object2));
        ((CreateNodeUtil)object).handleJoin(execNode, (ExecNode)((Object)object2));
        return object2;
    }

    private Workitem loadWorkitem(BPMContext object, long l2) throws Throwable {
        if ((object = WorkitemUtil.loadWorkitem((DefaultContext)object, (Long)l2)) == null) {
            return null;
        }
        ((Workitem)object).setAuditResult(this.info.getAuditResult());
        ((Workitem)object).setUserInfo(this.info.getUserInfo());
        ((Workitem)object).setResultInfo(Result.parseToString(this.info.getAuditResult()));
        return object;
    }
}

