/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.engine.data.row.RDirectTransition;
import com.bokesoft.yes.bpm.engine.data.table.TDirectTransition;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAudit;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

public class DirectAuditCheckProcess
implements IServiceProcess<DefaultContext> {
    public void process(DefaultContext object) throws Throwable {
        Document document = object.getDocument();
        if (document.isNew()) {
            return;
        }
        if (document.getDocumentTrack().contains(0, "") && !document.getDocumentTrack().contains(6, "")) {
            boolean bl = false;
            BPMContext bPMContext = new BPMContext((DefaultContext)object);
            BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstanceByOID(bPMContext, document.getOID(), true);
            if (bPMInstance == null) {
                return;
            }
            TDirectTransition tDirectTransition = bPMInstance.getInstanceData().getDirectTransition();
            tDirectTransition.load(object.getDBManager());
            object = tDirectTransition.iterator();
            while (object.hasNext()) {
                RDirectTransition rDirectTransition = (RDirectTransition)object.next();
                tDirectTransition.getVTDirectTransitionMap().get(rDirectTransition.getInlineNodeID()).internalAddRow(rDirectTransition);
            }
            for (RDirectTransition rDirectTransition : tDirectTransition.visableRows()) {
                if (!this.checkDataChanged(rDirectTransition, bPMInstance, document)) continue;
                rDirectTransition.setDeleted();
                bl = true;
            }
            if (bl) {
                bPMContext.getInstanceDataContainer().save();
            }
        }
    }

    private boolean checkDataChanged(RDirectTransition object, BPMInstance bPMInstance2, Document document) {
        for (BPMInstance bPMInstance2 : ((MetaAudit)bPMInstance2.getNodeByID(((RDirectTransition)object).getInlineNodeID(), ((RDirectTransition)object).getNodeID()).getNodeModel()).getDirectAuditCondition()) {
            DataTable dataTable = document.get(bPMInstance2.getKey());
            if (dataTable == null || dataTable.isEmpty() || bPMInstance2.getColumnKeyList().size() <= 0) continue;
            dataTable.beforeFirst();
            while (dataTable.next()) {
                if (dataTable.getState() != 2) continue;
                for (String string : bPMInstance2.getColumnKeyList()) {
                    if (dataTable.getMetaData().getColumnInfo(string).getDataTypeAction().compare(dataTable.getObject(string), dataTable.getOriginalObject(string)) == 0) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

