/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.cmd;

import com.bokesoft.yes.bpm.engine.data.row.RNode;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.instance.CreateNodeUtil;
import com.bokesoft.yes.bpm.engine.instance.VirtualInstance;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.timer.TimerProxy;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;

public class ForcibleMoveCmd
extends BPMServiceCmd {
    private int srcNode;
    private int tgtNode;
    private long instanceID;

    public IServiceCmd<BPMContext> newInstance() {
        return new ForcibleMoveCmd();
    }

    @Override
    public void dealArguments(BPMContext bPMContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.srcNode = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"sourceNode"));
        this.tgtNode = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"targetNode"));
        this.instanceID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"instanceID"));
    }

    @Override
    public Object doCmd(BPMContext bPMContext) throws Throwable {
        bPMContext = BPMContext.getBPMContext(bPMContext, (Long)this.instanceID);
        BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstance(bPMContext, this.instanceID);
        VirtualInstance virtualInstance = bPMInstance.getMainInstance();
        ExecNode execNode = null;
        if (this.srcNode != -1) {
            virtualInstance.getInstanceData().getToken().deleteTokenByNodeID(this.srcNode, bPMContext.getDBManager());
            execNode = bPMInstance.getNodeByID(-1, this.srcNode);
            RNode rNode = virtualInstance.getInstanceData().getNode().getNodeData(this.srcNode, bPMContext.getDBManager());
            if (rNode == null) {
                return "";
            }
            int n2 = rNode.getCountSeed();
            for (long l2 : virtualInstance.getInstanceData().getWorkitemInfo().getWorkitemIDByNodeID(this.srcNode, n2, bPMContext.getDBManager())) {
                bPMInstance.getInstanceData().getWorkitemData().deleteWorkitemData(bPMContext, l2);
                virtualInstance.getInstanceData().getWorkitemInfo().getWorkitemInfo(l2, bPMContext.getDBManager()).setDeleted();
                Workitem workitem = new Workitem();
                workitem.setWorkItemID(l2);
                bPMContext.setUpdateWorkitem(workitem);
                TimerProxy.removeNodeData(bPMContext, execNode);
            }
            virtualInstance.getInstanceData().getNode().getNodeData(this.srcNode, bPMContext.getDBManager()).setWorkitemID(-1L);
        }
        if (this.tgtNode != -1) {
            ExecNode execNode2;
            int n3 = virtualInstance.applyNewTokenID();
            virtualInstance.getInstanceData().getToken().createNewToken(n3, 0);
            bPMContext.setActiveTokenID(n3);
            try {
                execNode2 = bPMInstance.getNodeByID(-1, this.tgtNode);
            }
            catch (Throwable throwable) {
                execNode2 = this.createNode(bPMInstance.getMainInstance(), this.tgtNode, execNode, bPMContext);
            }
            execNode2.input(bPMContext);
        }
        bPMContext.getInstanceDataContainer().save();
        return "";
    }

    private ExecNode createNode(VirtualInstance object, int n2, ExecNode execNode, BPMContext bPMContext) throws Throwable {
        Object object2 = ((VirtualInstance)object).getMetaNodeByID(n2);
        object = new CreateNodeUtil(bPMContext, (VirtualInstance)object);
        object2 = ((CreateNodeUtil)object).createNode((MetaNode)object2);
        if (execNode != null) {
            ((CreateNodeUtil)object).handleExclusiveFork(execNode, (ExecNode)((Object)object2));
            ((CreateNodeUtil)object).handleJoin(execNode, (ExecNode)((Object)object2));
        }
        return object2;
    }

    @Override
    public String getCmd() {
        return "ForcibleMove";
    }

    public void setSrcNode(int n2) {
        this.srcNode = n2;
    }

    public void setTgtNode(int n2) {
        this.tgtNode = n2;
    }

    public void setInstanceID(long l2) {
        this.instanceID = l2;
    }
}

