/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.cmd;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.data.row.RInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.instance.VirtualInstance;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.util.SysTopicUtil;
import com.bokesoft.yes.bpm.workitem.TransitData;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.bpm.workitem.data.RWorkitem;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.LoadFormData;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.struct.document.Document;
import java.sql.Timestamp;
import org.json.JSONObject;

public class DirStartInstanceCmd
extends BPMServiceCmd {
    public static final String TAG = "DirStartInstance";
    private Long instanceID = -1L;
    private Document doc = null;
    private int auditResult = 1;
    private boolean keepParts = true;

    public IServiceCmd<BPMContext> newInstance() {
        return new DirStartInstanceCmd();
    }

    @Override
    public void dealArguments(BPMContext object, StringHashMap<Object> stringHashMap) throws Throwable {
        this.instanceID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"InstanceID"));
        if (stringHashMap.get((Object)"document") != null && ((String)stringHashMap.get((Object)"document")).length() != 0) {
            object = (String)stringHashMap.get((Object)"document");
            this.doc = new Document(null, -1L);
            this.doc.fromJSON(new JSONObject((String)object));
        }
        this.auditResult = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"auditResult"));
        this.keepParts = TypeConvertor.toBoolean((Object)stringHashMap.get((Object)"keepParts"));
    }

    @Override
    public Object doCmd(BPMContext bPMContext) throws Throwable {
        if (this.doc != null) {
            SysTopicUtil.assignSysTopic(bPMContext);
            new SaveData(this.doc.getObjectKey(), null, this.doc).midLaunchSave((DefaultContext)bPMContext);
        }
        bPMContext = BPMContext.getBPMContext(bPMContext, this.instanceID);
        BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstance(bPMContext, this.instanceID);
        RInstance rInstance = bPMInstance.getInstanceData().getInstance().getData();
        Object object = rInstance.getFormKey();
        rInstance = new LoadFormData((String)object, rInstance.getOID()).load((DefaultContext)bPMContext, null);
        Object object2 = bPMContext.getVE().getMetaFactory().getMetaForm((String)object);
        bPMContext.setFormKey((String)object);
        bPMContext.setDataObject(object2.getDataSource().getDataObject());
        bPMContext.setDocument((Document)rInstance);
        rInstance = bPMInstance.getInstanceData().getInstance().getData();
        rInstance.setInstanceState(1);
        object = bPMInstance.getMainInstance();
        object2 = ((VirtualInstance)object).getBeginNode();
        int n2 = object2.getID();
        long l2 = ((VirtualInstance)object).getInstanceData().getNode().getNodeData(n2, bPMContext.getDBManager()).getWorkitemID();
        MetaProcess object32 = BPMUtil.getProcessByInstance(bPMContext, bPMInstance);
        WorkitemUtil.unlockWorkitem(bPMContext, n2, rInstance.getInstanceID(), object32);
        if (l2 != -1L) {
            this.updateBeginWorkitem(bPMContext, bPMInstance);
            Workitem n4 = WorkitemUtil.loadWorkitem(bPMContext, (Long)l2);
            ((VirtualInstance)object).getInstanceData().getToken().deleteTokenByNodeID(object2.getID(), bPMContext.getDBManager());
            ((VirtualInstance)object).getInstanceData().getNode().getNodeData(n2, bPMContext.getDBManager()).setWorkitemID(-1L);
            if (n4.getTransits().size() == 0) {
                throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)28, (Object[])new Object[0]);
            }
            for (TransitData transitData : n4.getTransits().values()) {
                int n3 = transitData.getNodeID();
                ExecNode execNode = bPMInstance.getMainInstanceNodeByID(n3);
                bPMContext.setOperationType(2);
                transitData.setKeepParts(this.keepParts);
                bPMContext.setTransitData(transitData);
                int n5 = ((VirtualInstance)object).applyNewTokenID();
                ((VirtualInstance)object).getInstanceData().getToken().createNewToken(n5, n2);
                bPMContext.setActiveTokenID(n5);
                execNode.input(bPMContext);
            }
        }
        rInstance.setTransitTo(-1);
        rInstance.setTransWorkitem(-1L);
        bPMContext.getInstanceDataContainer().save();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("result", true);
        return jSONObject;
    }

    @Override
    public String getCmd() {
        return TAG;
    }

    public void setInstanceID(Long l2) {
        this.instanceID = l2;
    }

    public void setDoc(Document document) {
        this.doc = document;
    }

    public void setAuditResult(int n2) {
        this.auditResult = n2;
    }

    public void setKeepParts(boolean bl) {
        this.keepParts = bl;
    }

    public void updateBeginWorkitem(BPMContext bPMContext, BPMInstance bPMInstance) throws Throwable {
        Object object = bPMInstance.getMainInstance();
        int n2 = ((VirtualInstance)object).getBeginNode().getID();
        object = ((VirtualInstance)object).getInstanceData().getWorkitemInfo().getWorkitemIDByNodeID(n2, 0, bPMContext.getDBManager()).iterator();
        while (object.hasNext()) {
            long l2 = (Long)object.next();
            RWorkitem rWorkitem = bPMInstance.getInstanceData().getWorkitemData().getWorkitemData(bPMContext, l2);
            if (rWorkitem.getWorkitemState() != 1) continue;
            rWorkitem.setWorkitemState(2);
            rWorkitem.setAuditResult(this.auditResult);
            rWorkitem.setOperatorID(bPMContext.getCurUserID());
            rWorkitem.setFinishTime(new Timestamp(bPMContext.getDBManager().getCurTime()));
            bPMInstance.getInstanceData().getWorkitemData().deleteParticipatorData(l2);
        }
    }
}

