/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.model;

import com.bokesoft.yes.bpm.model.BPMNodeModel;
import com.bokesoft.yes.bpm.model.BPMProcessModel;
import com.bokesoft.yigo.meta.bpm.AbstractBPMElement;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaAssociation;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaExceptionFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransition;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class BPMProcessModelJsonConvertor {
    private final BPMProcessModel model;
    private final IMetaFactory metaFactory;
    private final String processStr;
    private final String projectKey;
    private final String locale;

    public BPMProcessModelJsonConvertor(VE vE, BPMProcessModel bPMProcessModel) throws Throwable {
        this.model = bPMProcessModel;
        this.metaFactory = vE.getMetaFactory();
        this.processStr = bPMProcessModel.getKey() + "_V" + bPMProcessModel.getVersion();
        bPMProcessModel = (ProcessDefinitionProfile)this.metaFactory.getMetaBPM().getProfileMap().get(this.processStr);
        String string = "";
        bPMProcessModel = bPMProcessModel.getProject();
        if (bPMProcessModel != null) {
            string = bPMProcessModel.getKey();
        }
        this.projectKey = string;
        this.locale = vE.getEnv().getLocale();
    }

    public JSONObject convert(MetaProcess metaProcess) throws Throwable {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("key", (Object)this.model.getKey());
        String string = MetaUtil.getProcessString((IMetaFactory)this.metaFactory, (String)this.projectKey, (String)this.processStr, (String)this.locale, (String)"BPM_Node", (String)metaProcess.getKey(), (String)metaProcess.getCaption());
        jSONObject.put("caption", (Object)string);
        jSONObject.put("version", this.model.getVersion());
        string = new JSONArray();
        for (BPMNodeModel bPMNodeModel : this.model.getNodes()) {
            MetaNode metaNode = (MetaNode)metaProcess.get(bPMNodeModel.getKey());
            if ((bPMNodeModel = this.convertNode(bPMNodeModel, metaNode)) == null) continue;
            string.put((Object)bPMNodeModel);
        }
        if (!string.isEmpty()) {
            jSONObject.put("nodes", (Object)string);
        }
        return jSONObject;
    }

    private JSONObject convertNode(BPMNodeModel object, MetaNode object2) throws Throwable {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", object.getID());
        jSONObject.put("key", (Object)object.getKey());
        jSONObject.put("caption", (Object)this.getCaption((AbstractBPMElement)object2));
        jSONObject.put("nodeType", object2.getNodeType());
        Object object3 = object2.getNodeGraphic();
        if (object3 != null) {
            jSONObject.put("x", object3.getX().intValue());
            jSONObject.put("y", object3.getY().intValue());
            jSONObject.put("width", object3.getWidth().intValue());
            jSONObject.put("height", object3.getHeight().intValue());
            jSONObject.put("image", (Object)object3.getImage());
            jSONObject.put("image_past", (Object)object3.getPastImage());
            jSONObject.put("image_last", (Object)object3.getLastImage());
            jSONObject.put("style", (Object)object3.getStyle());
        }
        object2 = object2.getTransitionCollection();
        object = object.getNextNodeIDs();
        if (object2 != null && object != null) {
            Object object4;
            object3 = new HashMap();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                object4 = (MetaTransition)object2.next();
                MetaNode metaNode = object4.getTargetNode();
                if (metaNode == null) continue;
                object3.put(metaNode.getID(), object4);
            }
            object2 = new JSONArray();
            object4 = object.iterator();
            while (object4.hasNext()) {
                int n2 = (Integer)object4.next();
                object = (MetaTransition)object3.get(n2);
                if (object == null || (object = this.convertTransition((MetaTransition)object)) == null) continue;
                object2.put(object);
            }
            jSONObject.put("transitions", object2);
        }
        return jSONObject;
    }

    private JSONObject convertTransition(MetaTransition metaTransition) throws Throwable {
        String string;
        JSONObject jSONObject = new JSONObject();
        if (metaTransition instanceof MetaAssociation) {
            string = "association";
        } else if (metaTransition instanceof MetaExceptionFlow) {
            string = "exception-flow";
        } else if (metaTransition instanceof MetaSequenceFlow) {
            string = "sequence-flow";
        } else {
            return null;
        }
        jSONObject.put("tag-name", (Object)string);
        jSONObject.put("id", metaTransition.getID().intValue());
        jSONObject.put("key", (Object)metaTransition.getKey());
        jSONObject.put("target-node-key", (Object)metaTransition.getTargetNodeKey());
        string = metaTransition.getTargetNode();
        if (string != null) {
            jSONObject.put("target-node-id", string.getID().intValue());
        }
        if ((metaTransition = metaTransition.getGraphic()) != null) {
            jSONObject.put("line-style", metaTransition.getLineStyle().intValue());
            jSONObject.put("style", (Object)metaTransition.getStyle());
        }
        return jSONObject;
    }

    private String getCaption(AbstractBPMElement abstractBPMElement) throws Throwable {
        return MetaUtil.getProcessString((IMetaFactory)this.metaFactory, (String)this.projectKey, (String)this.processStr, (String)this.locale, (String)"BPM_Node", (String)abstractBPMElement.getKey(), (String)abstractBPMElement.getCaption());
    }
}

