package com.bokesoft.yigo.bpm.message;

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecMessageReceive;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.meta.transform.InstanceState;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.util.ContextBuilder;

public class MessageReceiveImpl {

	private long instanceID = -1l;
	
	private int inlineNodeID = -1;
	
	private int targetNodeID = -1;
	
	public MessageReceiveImpl(long instanceID, int inlineNodeID, int targetNodeID) {
		this.instanceID = instanceID;
		this.inlineNodeID = inlineNodeID;
		this.targetNodeID = targetNodeID;
	}
	
	public void receiveMessage(String usrMsg) throws Throwable {
		DefaultContext context = ContextBuilder.create();
		BPMContext bpmContext = null;
		try {
			bpmContext = new BPMContext(context);
			BPMInstance instance = BPMInstanceFactory.getBPMInstance(bpmContext, instanceID);
			if (instance != null) {
				int state = instance.getInstanceData().getInstance().getData().getInstanceState();
				if (state != InstanceState.PROCESSING) {
					throw new Exception("Illegal instance state!");
				}
				inlineNodeID = inlineNodeID <=0 ? -1 : inlineNodeID;
				ExecNode node = instance.getNodeByID(inlineNodeID, targetNodeID);
				node.receiveMsg(bpmContext, usrMsg);
				bpmContext.getInstanceDataContainer().save();
				bpmContext.commit();
			}
		} catch (Exception e) {
			if (bpmContext != null) {
				bpmContext.rollback();
			}
			throw e;
		}finally {
			if (bpmContext != null) {
				bpmContext.close();
			}
		}
	}
}
