package com.bokesoft.yigo.bpm.dev;

import java.util.List;

import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperation;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.Participator;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerItemCollection;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.calendar.MetaWorkingCalendarCollection;
import com.bokesoft.yigo.mid.base.DefaultContext;

public interface Template {

	public List<MetaBPMOperation> getOperationList(DefaultContext context, MetaProcess pd, MetaNode node, Spoon Spoon) throws Throwable;

	public List<Participator> getParticipatorList(DefaultContext context, MetaProcess pd, MetaNode node, MetaNode parentNode, Spoon Spoon) throws Throwable;

	public MetaProcessMap getMapInfoByMetaKey(DefaultContext context, String dataObjectKey, String formKey) throws Throwable;
	
	public MetaTimerItemCollection getTimeritemList(DefaultContext context, MetaProcess pd, MetaNode node, Spoon Spoon) throws Throwable;
	
	public MetaWorkingCalendarCollection getWorkingCalendar(DefaultContext context, MetaProcess pd, MetaNode node, Spoon Spoon) throws Throwable;
	
	public String getCreateTrigger(DefaultContext context, MetaProcess pd, MetaNode node, Spoon Spoon) throws Throwable;
	
	public String getFinishTrigger(DefaultContext context, MetaProcess pd, MetaNode node, Spoon Spoon) throws Throwable;
	
	public boolean getAutoIgnoreNoParticipator(DefaultContext context, MetaProcess pd, MetaNode node, Spoon Spoon) throws Throwable;
	
	public Long getWorkitemID(DefaultContext context, MetaProcess pd, MetaNode node, Spoon Spoon) throws Throwable;
	
	public MetaPerm getPerm(DefaultContext context, MetaProcess pd, MetaNode node, Spoon Spoon) throws Throwable;
	
	public MetaProcess getDefination(DefaultContext context, String processKey, int ver, Spoon Spoon) throws Throwable;
	
	default MetaEventCollection getEventCollection(DefaultContext context, MetaProcess pd, Spoon Spoon) throws Throwable {
		return null;
	}
}
