package com.bokesoft.yigo.bpm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Map;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;

/**
 * 删除数据库流程
 * 
 * @author guowj
 *
 */
public class DeleteDBProcess {

	private String processKey = "";
	private int version = -1;
	
	public DeleteDBProcess(String processKey, int version) {
		this.processKey = processKey;
		this.version = version;
	}
	
	public void delete(DefaultContext context) throws Throwable {
		if(processKey.isEmpty() || version == -1){
			return;
		}
		checkDelete(context);
		deleteProcess(context);
		// 删除快照
		IMetaFactory factory = context.getVE().getMetaFactory();
		Iterator<Map.Entry<String, ProcessDefinitionProfile>> it = factory.getMetaBPM().getProfileMap().entrySet().iterator();
		while(it.hasNext()){
			Map.Entry<String, ProcessDefinitionProfile> entry = it.next();
			if(entry.getKey().equalsIgnoreCase(processKey + "_V" + version)){
				it.remove();
			}
		}
	}
	
	private void checkDelete(DefaultContext context) throws Throwable{
		IDBManager DBManager = context.getDBManager();
		PreparedStatement ps = null;
		ResultSet rs = null;
		String sql = "select "
				+ DBManager.keyWordEscape(SystemDBField.ALREADYDEPLOY)
				+ " from " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS) 
				+ " where "
				+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + "=? and "
				+ DBManager.keyWordEscape(SystemDBField.WF_VERID) + "=?";
		try{
			ps = DBManager.preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addStringArg(processKey);
			args.addIntArg(version);
			rs = DBManager.executeQuery(ps, sql, args);
			if(rs.next()){
				int alreadyDeploy = rs.getInt(1);
				// 不支持删除已部署的流程
				if(alreadyDeploy == 1){
					throw BPMError.getBPMError(context.getEnv(), BPMError.NOT_ALLOWED_DELETE_DEPLOYED_PROCESS);
				}
			}
		}finally{
			if(ps != null){
				ps.close();
			}
			if(rs != null){
				rs.close();
			}
		}
	}
	
	private void deleteProcess(DefaultContext context) throws Throwable{
		IDBManager DBManager = context.getDBManager();
		PreparedStatement ps = null;
		String sql = "delete from " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS) 
				+ " where "
				+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + "=? and "
				+ DBManager.keyWordEscape(SystemDBField.WF_VERID) + "=?";
		try{
			ps = DBManager.preparedUpdateStatement(sql);
			PSArgs args = new PSArgs();
			args.addStringArg(processKey);
			args.addIntArg(version);
			DBManager.executeUpdate(ps, sql, args);
			
		}finally{
			if(ps != null){
				ps.close();
			}
		}
	}
}
