package com.bokesoft.yes.bpm.extend.service;

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecUserTask;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.util.TypeConvertor;

public class EndorseTaskCmd extends BPMServiceCmd {

	public static final String TAG = "EndorseTask";

	private Long workitemID;

	private Long operatorID;

	private String launchInfo;
	
	private boolean hide = true;
	
	public EndorseTaskCmd(Long workitemID, Long operatorID, String launchInfo, boolean hide) {
		super();
		this.workitemID = workitemID;
		this.operatorID = operatorID;
		this.launchInfo = launchInfo;
		this.hide = hide;
	}

	public EndorseTaskCmd() {
	}

	@Override
	public void dealArguments(BPMContext context, StringHashMap<Object> arguments) throws Throwable {
		workitemID = TypeConvertor.toLong(arguments.get("WorkitemID"));
		operatorID = TypeConvertor.toLong(arguments.get("OperatorID"));
		launchInfo = TypeConvertor.toString(arguments.get("LaunchInfo"));
		hide = TypeConvertor.toBoolean(arguments.get("Hide"));
	}

	public String getCmd() {
		return TAG;
	}

	@Override
	public Object doCmd(BPMContext context) throws Throwable {
		Workitem workitem = WorkitemUtil.loadWorkitem(context, workitemID);
		if (workitem == null)
			return "";
		context = BPMContext.getBPMContext(context, workitem.getInstanceID());
		context.setUpdateWorkitem(workitem);

		BPMInstance instance = BPMInstanceFactory.getBPMInstance(context, workitem.getInstanceID());
		if (instance != null) {
			ExecUserTask node = (ExecUserTask) instance.getNodeByID(workitem.getInlineNodeID(), workitem.getNodeID());
			node.endorseTask(context, operatorID, launchInfo,hide);
		}
		context.getInstanceDataContainer().save();
		return null;
	}

	@Override
	public IServiceCmd<BPMContext> newInstance() {
		return new EndorseTaskCmd();
	}
}
