package com.bokesoft.yes.bpm.extend.service;

import org.json.JSONObject;

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.node.ExecUserTask;
import com.bokesoft.yes.bpm.meta.transform.PPObject;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.util.TypeConvertor;

public class BatchEndorseTaskCmd extends BPMServiceCmd {
	public static final String TAG_NAME = "BatchEndorseTask";
	
	private long wid = -1l;
	private PPObject pb = null;
	private String launchInfo = "";
	private boolean inOrder = false;
	private boolean hide = true;
	
	/**
	 * @return the wid
	 */
	public long getWid() {
		return wid;
	}

	/**
	 * @param wid the wid to set
	 */
	public void setWid(long wid) {
		this.wid = wid;
	}

	/**
	 * @return the pb
	 */
	public PPObject getPb() {
		return pb;
	}

	/**
	 * @param pb the pb to set
	 */
	public void setPb(PPObject pb) {
		this.pb = pb;
	}

	/**
	 * @return the launchInfo
	 */
	public String getLaunchInfo() {
		return launchInfo;
	}

	/**
	 * @param launchInfo the launchInfo to set
	 */
	public void setLaunchInfo(String launchInfo) {
		this.launchInfo = launchInfo;
	}

	/**
	 * @return the inOrder
	 */
	public boolean isInOrder() {
		return inOrder;
	}

	/**
	 * @param inOrder the inOrder to set
	 */
	public void setInOrder(boolean inOrder) {
		this.inOrder = inOrder;
	}

	public boolean isHide() {
		return hide;
	}

	public void setHide(boolean hide) {
		this.hide = hide;
	}

	@Override
	public IServiceCmd<BPMContext> newInstance() {
		return new BatchEndorseTaskCmd();
	}

	@Override
	public void dealArguments(BPMContext context, StringHashMap<Object> arguments) throws Throwable {
		wid = TypeConvertor.toLong(arguments.get("WorkitemID"));
		String pbstr = TypeConvertor.toString(arguments.get("PPObject"));
		if (pbstr != null && !pbstr.isEmpty()) {
			pb = new PPObject();
			pb.fromJSON(new JSONObject(pbstr));
		}
		launchInfo = TypeConvertor.toString(arguments.get("LaunchInfo"));
		inOrder = TypeConvertor.toBoolean(arguments.get("InOrder"));
		hide = TypeConvertor.toBoolean(arguments.get("Hide"));
	}

	@Override
	public Object doCmd(BPMContext context) throws Throwable {
		Workitem wi = WorkitemUtil.loadWorkitem(context, wid);
		if (wi == null) {
			return false;
		}
		
		context = BPMContext.getBPMContext(context, wi.getInstanceID());
		context.setUpdateWorkitem(wi);
		
		BPMInstance instance = BPMInstanceFactory.getBPMInstance(context, wi.getInstanceID());
		ExecNode node = instance.getNodeByID(wi.getInlineNodeID(), wi.getNodeID());
		if (node instanceof ExecUserTask) {
			((ExecUserTask)node).batchEndorseTask(context, launchInfo, pb, inOrder, hide);
		}
		
		context.getInstanceDataContainer().save();
		
		return true;
	}

	@Override
	public String getCmd() {
		return TAG_NAME;
	}

}
