package com.bokesoft.yes.bpm.model;

import java.util.List;

/**
 * BPM节点模型
 */

public class BPMNodeModel {

	/** 节点数字标识 */
	private int id = -1;
	/** 节点字符串标识 */
	private String key = null;
	/** 节点类型，取值范围参考{@link BPMNodeModelType} */
	private int type;
	/** 后续节点id集合 */
	private List<Integer> nextNodeIDs = null;

	/**
	 * 取得节点数字标识
	 * 
	 * @return 数字标识
	 */
	public int getID() {
		return id;
	}

	/**
	 * 设置节点数字标识
	 * 
	 * @param id 数字标识
	 */
	public void setID(int id) {
		this.id = id;
	}

	/**
	 * 取得节点字符串标识
	 * 
	 * @return 字符串标识
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置节点字符串标识
	 * 
	 * @param key 字符串标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 取得节点类型
	 * 
	 * @return 节点类型，取值范围参考{@link BPMNodeModelType}
	 */
	public int getType() {
		return type;
	}

	/**
	 * 设置节点类型
	 * 
	 * @param type 节点类型，取值范围参考{@link BPMNodeModelType}
	 */
	public void setType(int type) {
		this.type = type;
	}

	/**
	 * 取得后续节点id集合
	 * 
	 * @return 后续节点id集合
	 */
	public List<Integer> getNextNodeIDs() {
		return nextNodeIDs;
	}

	/**
	 * 设置后续节点id集合
	 * 
	 * @param type 后续节点id集合
	 */
	public void setNextNodeIDs(List<Integer> nextNodeIDs) {
		this.nextNodeIDs = nextNodeIDs;
	}
}
