package com.bokesoft.yes.bpm.meta.transform.elements;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;


public abstract class TransBPMTransition extends TransBPMObject {
	/** 线型 */
	private int lineStyle = -1;
	/** 目标节点的标识 */
	private String targetNodeKey = "";
	
	private int targetNodeID = -1;
	
	private String style = "";
	
	private String tiptop = "";
	
	/** 是否在流转路径中*/
	private int elementState = ElementState.NORMAL;
	
	public void setLineStyle(int lineStyle) {
		this.lineStyle = lineStyle;
	}
	
	public int getLineStyle() {
		return this.lineStyle;
	}
	
	public void setTargetNodeKey(String targetNodeKey) {
		this.targetNodeKey = targetNodeKey;
	}
	
	public String getTargetNodeKey() {
		return this.targetNodeKey;
	}
	
	public int getTargetNodeID() {
		return this.targetNodeID;
	}
	
	public void setTargetNodeID(int targetID) {
		this.targetNodeID = targetID;
	}
	
//	public boolean getInPath(){
//		return this.inPath;
//	}
//	
//	public void setInPath(boolean inPath) {
//		this.inPath = inPath;
//	}
	
	public int getElementState() {
		return elementState;
	}
	
	public void setElementState(int elementState) {
		this.elementState = elementState;
	}
	
	public String getStyle() {
		return style;
	}
	
	public void setStyle(String style) {
		this.style = style;
	}
	
	public String getTiptop() {
		return tiptop;
	}
	
	public void setTiptop(String tiptop) {
		this.tiptop = tiptop;
	}
	
	
	public static final String tag_line_style = "line-style";
//	public static final String tag_inpath = "inpath";
	public static final String tag_target_node_key = "target-node-key";
	public static final String tag_target_node_id = "target-node-id";
	
	public JSONObject toJSON() throws SerializationException {
		JSONObject json = super.toJSON();
		json.put(tag_line_style, this.lineStyle);
//		json.put(tag_inpath, inPath);
		json.put(tag_state, this.elementState);
		json.put(tag_target_node_key, this.targetNodeKey);
		json.put(tag_target_node_id, this.targetNodeID);
		json.put(TransBPMNode.tag_style, this.style);
		json.put("tiptop", this.tiptop);
		return json;
	}

	public void fromJSON(JSONObject json) throws SerializationException {
		super.fromJSON(json);
		this.lineStyle = json.optInt(tag_line_style);
//		this.inPath = json.optBoolean(tag_inpath);
		this.elementState = json.optInt(tag_state);
		this.targetNodeKey = json.optString(tag_target_node_key);
		this.targetNodeID = json.optInt(tag_target_node_id);
		this.style = json.optString(TransBPMNode.tag_style);
		this.tiptop = json.optString("tiptop");
	}
}
