/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.meta.transform.graph;

import com.bokesoft.yes.bpm.meta.transform.graph.TransBPMGraph;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaNodeGraphic;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimline;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlinePosition;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTransitionGraphic;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaAssociation;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaExceptionFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransition;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class BPMGraphConvertor {
    private JSONObject transition2JSON(MetaTransition metaTransition) {
        JSONObject jSONObject = new JSONObject();
        MetaTransitionGraphic metaTransitionGraphic = metaTransition.getGraphic();
        jSONObject.put("id", (Object)metaTransition.getID());
        jSONObject.put("key", (Object)metaTransition.getKey());
        jSONObject.put("line-style", (Object)metaTransitionGraphic.getLineStyle());
        jSONObject.put("target-node-key", (Object)metaTransition.getTargetNodeKey());
        if (metaTransition.getTargetNode() != null) {
            jSONObject.put("target-node-id", (Object)metaTransition.getTargetNode().getID());
        }
        if (metaTransition instanceof MetaAssociation) {
            jSONObject.put("tag-name", (Object)"association");
        } else if (metaTransition instanceof MetaExceptionFlow) {
            jSONObject.put("tag-name", (Object)"exception-flow");
        } else if (metaTransition instanceof MetaSequenceFlow) {
            jSONObject.put("tag-name", (Object)"sequence-flow");
        }
        return jSONObject;
    }

    private JSONObject node2JSON(MetaNode object) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", (Object)object.getID());
        jSONObject.put("key", (Object)object.getKey());
        MetaNodeGraphic metaNodeGraphic = object.getNodeGraphic();
        jSONObject.put("x", (Object)metaNodeGraphic.getX());
        jSONObject.put("y", (Object)metaNodeGraphic.getY());
        jSONObject.put("width", (Object)metaNodeGraphic.getWidth());
        jSONObject.put("height", (Object)metaNodeGraphic.getHeight());
        jSONObject.put("image", (Object)metaNodeGraphic.getImage());
        jSONObject.put("image_past", (Object)metaNodeGraphic.getPastImage());
        jSONObject.put("image_last", (Object)metaNodeGraphic.getLastImage());
        jSONObject.put("caption", (Object)object.getCaption());
        int n = object.getNodeType();
        switch (n) {
            case 0: {
                jSONObject.put("tag-name", (Object)"begin");
                break;
            }
            case 1: {
                jSONObject.put("tag-name", (Object)"end");
                break;
            }
            case 2: {
                jSONObject.put("tag-name", (Object)"user-task");
                break;
            }
            case 3: {
                jSONObject.put("tag-name", (Object)"audit");
                break;
            }
            case 4: {
                jSONObject.put("tag-name", (Object)"countersign");
                break;
            }
            case 5: {
                jSONObject.put("tag-name", (Object)"decision");
                break;
            }
            case 6: {
                jSONObject.put("tag-name", (Object)"sub-process");
                break;
            }
            case 7: {
                jSONObject.put("tag-name", (Object)"fork");
                break;
            }
            case 8: {
                jSONObject.put("tag-name", (Object)"join");
                break;
            }
            case 9: {
                jSONObject.put("tag-name", (Object)"event");
                break;
            }
            case 10: {
                jSONObject.put("tag-name", (Object)"state");
                break;
            }
            case 11: {
                jSONObject.put("tag-name", (Object)"timer");
                break;
            }
            case 12: {
                jSONObject.put("tag-name", (Object)"inline");
                break;
            }
            case 13: {
                jSONObject.put("tag-name", (Object)"data-map");
                break;
            }
            case 14: {
                jSONObject.put("tag-name", (Object)"complex-join");
                break;
            }
            case 15: {
                jSONObject.put("tag-name", (Object)"manual-task");
                break;
            }
            case 16: {
                jSONObject.put("tag-name", (Object)"exclusive-fork");
                break;
            }
            case 17: {
                jSONObject.put("tag-name", (Object)"service-task");
                break;
            }
            case 18: {
                jSONObject.put("tag-name", (Object)"branch-end");
                break;
            }
            case 19: {
                jSONObject.put("tag-name", (Object)"state-action");
                break;
            }
            case 20: {
                jSONObject.put("tag-name", (Object)"multi-task");
                break;
            }
            case 21: {
                jSONObject.put("tag-name", (Object)"multi-audit");
                break;
            }
            case 25: {
                jSONObject.put("tag-name", (Object)"message-send");
                break;
            }
            case 26: {
                jSONObject.put("tag-name", (Object)"message-receive");
                break;
            }
            case 28: {
                jSONObject.put("tag-name", (Object)"anchor");
                break;
            }
            case 27: {
                jSONObject.put("tag-name", (Object)"exclusive-join");
            }
        }
        jSONObject.put("nodeType", n);
        object = object.getTransitionCollection();
        if (object != null && !object.empty()) {
            JSONArray jSONArray = new JSONArray();
            object = object.iterator();
            while (object.hasNext()) {
                MetaTransition metaTransition = (MetaTransition)object.next();
                jSONArray.put((Object)this.transition2JSON(metaTransition));
            }
            jSONObject.put("transitions", (Object)jSONArray);
        }
        return jSONObject;
    }

    private JSONObject swim2JSON(MetaSwimline metaSwimline) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", (Object)metaSwimline.getID());
        jSONObject.put("key", (Object)metaSwimline.getKey());
        MetaSwimlinePosition metaSwimlinePosition = metaSwimline.getPosition();
        jSONObject.put("x", metaSwimlinePosition.getX());
        jSONObject.put("y", metaSwimlinePosition.getY());
        metaSwimlinePosition = metaSwimline.getSize();
        jSONObject.put("width", metaSwimlinePosition.getWidth());
        jSONObject.put("height", metaSwimlinePosition.getHeight());
        jSONObject.put("caption", (Object)metaSwimline.getCaption());
        jSONObject.put("direction", (Object)metaSwimline.getDirection());
        return jSONObject;
    }

    public JSONObject toJSON(MetaProcess object) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("key", (Object)object.getKey());
        jSONObject.put("caption", (Object)object.getCaption());
        jSONObject.put("version", (Object)object.getVersion());
        if (!object.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            JSONArray jSONArray2 = new JSONArray();
            Iterator iterator = object.entryIterator();
            object = object.getSwimlineCollection().entryIterator();
            while (iterator.hasNext()) {
                MetaNode metaNode = (MetaNode)((Map.Entry)iterator.next()).getValue();
                jSONArray.put((Object)this.node2JSON(metaNode));
            }
            while (object.hasNext()) {
                iterator = (MetaSwimline)((Map.Entry)object.next()).getValue();
                jSONArray2.put((Object)this.swim2JSON((MetaSwimline)iterator));
            }
            jSONObject.put("nodes", (Object)jSONArray);
            jSONObject.put("swims", (Object)jSONArray2);
        }
        return jSONObject;
    }

    public TransBPMGraph toGraph(JSONObject jSONObject) throws Throwable {
        TransBPMGraph transBPMGraph = new TransBPMGraph();
        transBPMGraph.fromJSON(jSONObject);
        return transBPMGraph;
    }
}

