/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.index;

import com.bokesoft.erp.webdesigner.language.common.SAXHelper;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndex;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndexEnum;
import java.io.File;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public abstract class KeyIndexWriter<T extends KeyIndex> {
    public void writeDefine(KeyIndexEnum keyIndexEnum, List<T> list) throws Exception {
        this.a(keyIndexEnum, list, KeyIndexEnum::getDefineFile);
    }

    public void writeRefer(KeyIndexEnum keyIndexEnum, List<T> list) throws Exception {
        this.a(keyIndexEnum, list, KeyIndexEnum::getReferFile);
    }

    private void a(KeyIndexEnum keyIndexEnum, List<T> list, Function<KeyIndexEnum, File> function) throws Exception {
        File file = function.apply(keyIndexEnum);
        Function<T, Attributes> function2 = this.a();
        String string = keyIndexEnum.getCode();
        SAXHelper.transform(file, string, list, function2);
    }

    private Function<T, Attributes> a() {
        return keyIndex -> {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "", "FileID", "", keyIndex.getFileID());
            attributesImpl.addAttribute("", "", "Key", "", keyIndex.getKey());
            String string = keyIndex.getCaption();
            if (StringUtils.isNotBlank((CharSequence)string)) {
                attributesImpl.addAttribute("", "", "Caption", "", string);
            }
            attributesImpl.addAttribute("", "", "Line", "", String.valueOf(keyIndex.getLine()));
            attributesImpl.addAttribute("", "", "Column", "", String.valueOf(keyIndex.getColumn()));
            attributesImpl.addAttribute("", "", "Snapshot", "", keyIndex.getSnapshot());
            this.innerAttributeMapper(keyIndex, attributesImpl);
            return attributesImpl;
        };
    }

    protected void innerAttributeMapper(T t, AttributesImpl attributesImpl) {
    }
}

