/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.index;

import com.bokesoft.erp.webdesigner.language.common.ClassHelper;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.FileIndexManager;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFileWrapper;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexKey;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndex;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndexEnum;
import com.bokesoft.yes.common.log.LogSvr;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class KeyIndexBuilder<T extends KeyIndex> {
    private static final Pattern START_ELEMENT_PATTERN = Pattern.compile("<(\\w+)");
    private static final Pattern END_ELEMENT_PATTERN = Pattern.compile("[^]]>");
    private static final Pattern PURE_ELEMENT_PATTERN = Pattern.compile("^(?:\\s*<(?:/\\w[^>]*>|\\w+\\s*/?>))*$");
    private static final Pattern CRLF_PATTERN = Pattern.compile("[\r\n]+");
    private static final Pattern DEFINE_KEY_PATTERN = Pattern.compile("\\sKey\\s*=\\s*\"(\\w+)\"");
    private static final Pattern DEFINE_CAPTION_PATTERN = Pattern.compile("\\sCaption\\s*=\\s*\"([^\"]+)\"");
    protected static final Pattern DATA_OBJECT_REFER_PATTERN = Pattern.compile("\\sRefObjectKey\\s*=\\s*\"(\\w+)\"");
    private static KeyIndexBuilder<? extends KeyIndex> instance;

    public static synchronized KeyIndexBuilder<? extends KeyIndex> getInstance() {
        if (Objects.isNull(instance)) {
            instance = new KeyIndexBuilder();
        }
        return instance;
    }

    public Pair<List<T>, List<T>> build(IndexFileWrapper indexFileWrapper) {
        List<T> list = Collections.synchronizedList(new ArrayList());
        List<T> list2 = Collections.synchronizedList(new ArrayList());
        String string = indexFileWrapper.getFileID();
        String string2 = indexFileWrapper.getFile().getName();
        String string3 = "";
        String string4 = "";
        int n = 0;
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(indexFileWrapper.getTmpFile().toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                String string5;
                while ((string5 = bufferedReader.readLine()) != null) {
                    String string6 = string5;
                    ++n;
                    if (StringUtils.isBlank((CharSequence)string6) || PURE_ELEMENT_PATTERN.matcher(string6).matches()) continue;
                    string4 = this.b(string4, string6);
                    list2.addAll(this.a(string, string4, n, string6));
                    Matcher matcher = START_ELEMENT_PATTERN.matcher(string6);
                    if (!matcher.find()) continue;
                    String string7 = matcher.group(1);
                    String string8 = string6;
                    boolean bl = END_ELEMENT_PATTERN.matcher(string6).find();
                    while (!bl && (string5 = bufferedReader.readLine()) != null) {
                        string6 = string5;
                        string4 = this.b(string4, string6);
                        list2.addAll(this.a(string, string4, ++n, string6));
                        bl = END_ELEMENT_PATTERN.matcher(string6).find();
                        string8 = string8.concat("\r\n").concat(string6);
                    }
                    if (!bl) continue;
                    string4 = this.b(string4, string8, string7);
                    string3 = this.a(string2, string8, string3);
                    list.addAll(this.a(string, string4, n, string8, string7));
                }
                FileIndexManager.setCaption(indexFileWrapper.getFileID(), string3);
                return Pair.of(list, list2);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    private List<T> a(String string, String string2, int n, String string3, String string4) {
        List<KeyIndex> list = Collections.synchronizedList(new ArrayList());
        KeyIndexEnum[] keyIndexEnumArray = KeyIndexEnum.values();
        int n2 = keyIndexEnumArray.length;
        int n3 = 0;
        while (n3 < n2) {
            KeyIndexEnum keyIndexEnum = keyIndexEnumArray[n3];
            KeyIndexBuilder<? extends KeyIndex> keyIndexBuilder = keyIndexEnum.getBuilder();
            if (keyIndexBuilder.a(string4, string3)) {
                String[] stringArray = CRLF_PATTERN.split(string3);
                int n4 = stringArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Matcher matcher;
                    String string5 = stringArray[n4 - n5 - 1];
                    if (!StringUtils.isBlank((CharSequence)string5) && (matcher = DEFINE_KEY_PATTERN.matcher(string5)).find()) {
                        String string6 = matcher.group(1);
                        int n6 = n - n5;
                        int n7 = matcher.start(1) + 1;
                        String string7 = "";
                        Matcher matcher2 = DEFINE_CAPTION_PATTERN.matcher(string3);
                        if (matcher2.find()) {
                            string7 = matcher2.group(1);
                        }
                        KeyIndex keyIndex = (KeyIndex)ClassHelper.newParameterInstance(keyIndexBuilder.getClass());
                        keyIndex.setFileID(string);
                        keyIndex.setKey(string6);
                        keyIndex.setCaption(string7);
                        keyIndex.setLine(n6);
                        keyIndex.setColumn(n7);
                        int n8 = StringUtils.length((CharSequence)string5);
                        if (n8 < 100) {
                            keyIndex.setSnapshot(string5);
                        } else {
                            int n9 = Math.max(n7 - 30, 0);
                            int n10 = Math.min(n7 + 70, n8);
                            keyIndex.setSnapshot(StringUtils.substring((String)string5, (int)n9, (int)n10));
                        }
                        keyIndexBuilder.a(keyIndex, string2);
                        list.add(keyIndex);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return list;
    }

    protected void a(KeyIndex keyIndex, String string) {
    }

    private List<T> a(String string, String string2, int n, String string3) {
        List<KeyIndex> list = Collections.synchronizedList(new ArrayList());
        KeyIndexEnum[] keyIndexEnumArray = KeyIndexEnum.values();
        int n2 = keyIndexEnumArray.length;
        int n3 = 0;
        while (n3 < n2) {
            KeyIndexEnum keyIndexEnum = keyIndexEnumArray[n3];
            KeyIndexBuilder<? extends KeyIndex> keyIndexBuilder = keyIndexEnum.getBuilder();
            List<IndexKey> list2 = keyIndexBuilder.a(string3);
            for (IndexKey indexKey : list2) {
                KeyIndex keyIndex = (KeyIndex)ClassHelper.newParameterInstance(keyIndexBuilder.getClass());
                keyIndex.setKey(indexKey.getKey());
                keyIndex.setFileID(string);
                keyIndex.setLine(n);
                keyIndex.setColumn(indexKey.getColumn());
                int n4 = StringUtils.length((CharSequence)string3);
                if (n4 < 100) {
                    keyIndex.setSnapshot(string3);
                } else {
                    int n5 = Math.max(indexKey.getColumn() - 30, 0);
                    int n6 = Math.min(indexKey.getColumn() + 70, n4);
                    keyIndex.setSnapshot(StringUtils.substring((String)string3, (int)n5, (int)n6));
                }
                keyIndexBuilder.b(keyIndex, string2);
                list.add(keyIndex);
            }
            ++n3;
        }
        return list;
    }

    protected void b(KeyIndex keyIndex, String string) {
    }

    private String a(String string, String string2, String string3) {
        if (StringUtils.isBlank((CharSequence)string3)) {
            Matcher matcher = DEFINE_CAPTION_PATTERN.matcher(string2);
            string3 = matcher.find() ? matcher.group(1) : StringUtils.substringBeforeLast((String)string, (String)".");
        }
        return string3;
    }

    private String b(String string, String string2) {
        Matcher matcher;
        if (StringUtils.isBlank((CharSequence)string) && (matcher = DATA_OBJECT_REFER_PATTERN.matcher(string2)).find()) {
            string = matcher.group(1);
        }
        return string;
    }

    private String b(String string, String string2, String string3) {
        Matcher matcher;
        if (StringUtils.isBlank((CharSequence)string) && StringUtils.equals((CharSequence)string3, (CharSequence)"DataObject") && (matcher = DEFINE_KEY_PATTERN.matcher(string2)).find()) {
            return matcher.group(1);
        }
        return string;
    }

    protected boolean a(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    protected Pattern a() {
        throw new UnsupportedOperationException();
    }

    protected List<IndexKey> a(String string) {
        Pattern pattern = this.a();
        if (Objects.isNull(pattern)) {
            return Collections.emptyList();
        }
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            int n = matcher.start(1) + 1;
            return Collections.singletonList(new IndexKey(string2, n));
        }
        return Collections.emptyList();
    }
}

