/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.index;

import com.bokesoft.yes.common.log.LogSvr;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public final class IndexFileWrapper {
    private final String a;
    private final String b;
    private final long c;
    private final long d;
    private final File e;
    private final File f;

    private IndexFileWrapper(File file, File file2) {
        try {
            String string;
            if (Objects.isNull(file2)) {
                file2 = file;
            }
            this.b = string = file.getCanonicalPath();
            this.e = file;
            this.f = file2;
            if (file2.exists()) {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(file2.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                this.a = this.a(string, basicFileAttributes);
                this.c = basicFileAttributes.lastModifiedTime().toMillis();
                this.d = basicFileAttributes.size();
            } else {
                this.a = "";
                this.c = -1L;
                this.d = 0L;
            }
        }
        catch (IOException iOException) {
            LogSvr.getInstance().error(iOException.getMessage(), (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public String getFileID() {
        return this.a;
    }

    public String getPath() {
        return this.b;
    }

    public long getLastModified() {
        return this.c;
    }

    public long getSize() {
        return this.d;
    }

    public File getFile() {
        return this.e;
    }

    public File getTmpFile() {
        return this.f;
    }

    private String a(String string, BasicFileAttributes basicFileAttributes) throws IOException {
        int n = string.toLowerCase(Locale.ENGLISH).hashCode() ^ 0x12D591;
        return String.valueOf(n) + "/" + basicFileAttributes.size() + "/" + basicFileAttributes.lastModifiedTime().toMillis();
    }

    public static IndexFileWrapper newInstance(File file) {
        if (file.isDirectory()) {
            return null;
        }
        return new IndexFileWrapper(file, file);
    }

    public static IndexFileWrapper newInstance(String string, String string2) {
        File file = FileUtils.getFile((String[])new String[]{string});
        if (file.isDirectory()) {
            return null;
        }
        File file2 = StringUtils.isNotBlank((CharSequence)string2) ? FileUtils.getFile((String[])new String[]{string2}) : file;
        return new IndexFileWrapper(file, file2);
    }

    public static String toBackFilePath(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return "";
        }
        return string.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
    }

    public static String toFrontFilePath(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return "";
        }
        return string.replace("/", File.separator).replace("\\\\", File.separator).replace(File.separator, "\\");
    }
}

