/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.index;

import com.bokesoft.erp.webdesigner.language.application.model.KeyParams;
import com.bokesoft.erp.webdesigner.language.application.model.KeyPosition;
import com.bokesoft.erp.webdesigner.language.application.service.TextDocumentService;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.FileIndex;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.FileIndexLoader;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.FileIndexManager;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFileWrapper;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexTimerTask;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndex;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndexBuilder;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndexEnum;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndexLoader;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndexManager;
import com.bokesoft.yes.common.log.LogSvr;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.xml.sax.SAXException;

public class IndexFacade {
    public static final IOFileFilter FILE_FILTER = new SuffixFileFilter("xml");
    public static final IOFileFilter DIR_FILTER = FileFilterUtils.notFileFilter((IOFileFilter)new NameFileFilter(new String[]{"Data", "Formula", "Resource", "i18n", "initializeData", "properties", "erp-solution-update"}));
    private static boolean flushed = false;

    public static void init(Collection<String> collection) {
        Collection<IndexFileWrapper> collection2 = IndexFacade.a(collection);
        Set set = collection2.stream().map(IndexFileWrapper::getFileID).collect(Collectors.toSet());
        List<FileIndex> list = IndexFacade.load();
        Set set2 = list.stream().map(FileIndex::getFileID).collect(Collectors.toSet());
        HashSet<String> hashSet = new HashSet<String>(set2);
        hashSet.removeAll(set);
        IndexFacade.remove(hashSet);
        Set<IndexFileWrapper> set3 = collection2.stream().filter(indexFileWrapper -> !set2.contains(indexFileWrapper.getFileID())).collect(Collectors.toSet());
        IndexFacade.build(set3);
        if (!Objects.equals(set2, set)) {
            IndexFacade.write();
        }
        Timer timer = new Timer();
        IndexTimerTask indexTimerTask = new IndexTimerTask();
        timer.scheduleAtFixedRate((TimerTask)indexTimerTask, 0L, 300000L);
    }

    private static Collection<IndexFileWrapper> a(Collection<String> collection) {
        Function<String, Stream> function = string -> {
            Collection collection = FileUtils.listFiles((File)FileUtils.getFile((String[])new String[]{string}), (IOFileFilter)FILE_FILTER, (IOFileFilter)DIR_FILTER);
            return collection.stream().map(IndexFileWrapper::newInstance);
        };
        return collection.stream().flatMap(function).collect(Collectors.toSet());
    }

    public static List<FileIndex> load() {
        try {
            List<FileIndex> list = FileIndexLoader.load();
            FileIndexManager.addAll(list);
            KeyIndexEnum[] keyIndexEnumArray = KeyIndexEnum.values();
            int n = keyIndexEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                KeyIndexEnum keyIndexEnum = keyIndexEnumArray[n2];
                KeyIndexLoader<? extends KeyIndex> keyIndexLoader = keyIndexEnum.getLoader();
                List<? extends KeyIndex> list2 = keyIndexLoader.loadDefine(keyIndexEnum);
                KeyIndexManager.addAllDefine(keyIndexEnum, list2);
                List<? extends KeyIndex> list3 = keyIndexLoader.loadRefer(keyIndexEnum);
                KeyIndexManager.addAllRefer(keyIndexEnum, list3);
                ++n2;
            }
            return list;
        }
        catch (SAXException sAXException) {
            LogSvr.getInstance().error(sAXException.getMessage(), (Throwable)sAXException);
            return Collections.emptyList();
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static void reload(IndexFileWrapper indexFileWrapper) {
        if (Objects.isNull(indexFileWrapper)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)indexFileWrapper.getFileID()) && FileIndexManager.contains(indexFileWrapper.getFileID())) {
            return;
        }
        try {
            String string = FileIndexManager.getFileID(indexFileWrapper.getPath());
            if (StringUtils.isNotBlank((CharSequence)string)) {
                IndexFacade.remove(Collections.singleton(string));
            }
            if (indexFileWrapper.getFile().exists()) {
                IndexFacade.build(Collections.singleton(indexFileWrapper));
            }
            IndexFacade.write();
        }
        catch (Exception exception) {
            LogSvr.getInstance().error("\u7d22\u5f15Reload\u5931\u8d25\uff01FilePath: " + indexFileWrapper.getPath(), (Throwable)exception);
        }
    }

    public static void build(Set<IndexFileWrapper> set) {
        List<FileIndex> list = set.stream().map(FileIndex::newInstance).collect(Collectors.toList());
        FileIndexManager.addAll(list);
        Consumer<IndexFileWrapper> consumer = indexFileWrapper -> {
            KeyIndexBuilder<KeyIndex> keyIndexBuilder = KeyIndexBuilder.getInstance();
            Pair<List<KeyIndex>, List<KeyIndex>> pair = keyIndexBuilder.build((IndexFileWrapper)indexFileWrapper);
            KeyIndexManager.addAllDefine((Collection)pair.getLeft());
            KeyIndexManager.addAllRefer((Collection)pair.getRight());
        };
        set.parallelStream().forEach(consumer);
    }

    public static void write() {
        IndexFacade.setFlushed(false);
    }

    public static void remove(Set<String> set) {
        try {
            FileIndexManager.removeAll(set);
            KeyIndexManager.removeAllDefine(set);
            KeyIndexManager.removeAllRefer(set);
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static boolean isReferenced(KeyIndexEnum keyIndexEnum, String string) {
        KeyParams keyParams = new KeyParams();
        keyParams.setType(keyIndexEnum.getCode());
        keyParams.setKey(string);
        List<KeyPosition> list = TextDocumentService.references(keyParams);
        return CollectionUtils.isNotEmpty(list);
    }

    public static boolean isFlushed() {
        return flushed;
    }

    public static void setFlushed(boolean bl) {
        flushed = bl;
    }
}

