/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.index;

import com.bokesoft.erp.webdesigner.language.common.SAXHelper;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.FileIndex;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.FileIndexManager;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class FileIndexWriter {
    private static final Function<FileIndex, Attributes> MAPPER = fileIndex -> {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "FileID", "", fileIndex.getFileID());
        String string = fileIndex.getCaption();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            attributesImpl.addAttribute("", "", "Caption", "", string);
        }
        attributesImpl.addAttribute("", "", "LastModified", "", String.valueOf(fileIndex.getLastModified()));
        attributesImpl.addAttribute("", "", "Size", "", String.valueOf(fileIndex.getSize()));
        attributesImpl.addAttribute("", "", "Path", "", fileIndex.getPath());
        return attributesImpl;
    };

    public static void write() throws Exception {
        List<FileIndex> list = FileIndexManager.getList();
        SAXHelper.transform(FileIndex.FILE, "File", list, MAPPER);
    }
}

