/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.index;

import com.bokesoft.erp.webdesigner.language.infrastructure.index.FileIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FileIndexManager {
    private static final List<FileIndex> LIST = Collections.synchronizedList(new ArrayList());
    private static final Map<String, FileIndex> ID_MAP = Collections.synchronizedMap(new HashMap());
    private static final Map<String, FileIndex> PATH_MAP = Collections.synchronizedMap(new HashMap());

    public static boolean contains(String string) {
        return ID_MAP.containsKey(string);
    }

    public static FileIndex get(String string) {
        return ID_MAP.get(string);
    }

    public static String getPath(String string) {
        FileIndex fileIndex = ID_MAP.get(string);
        if (Objects.nonNull(fileIndex)) {
            return fileIndex.getPath();
        }
        return "";
    }

    public static String getFileID(String string) {
        FileIndex fileIndex = PATH_MAP.get(string);
        if (Objects.nonNull(fileIndex)) {
            return fileIndex.getFileID();
        }
        return "";
    }

    public static List<FileIndex> getList() {
        return LIST;
    }

    public static void setCaption(String string, String string2) {
        ID_MAP.get(string).setCaption(string2);
    }

    public static void addAll(Collection<FileIndex> collection) {
        LIST.addAll(collection);
        FileIndexManager.a();
    }

    public static void removeAll(Collection<String> collection) {
        LIST.removeIf(fileIndex -> collection.contains(fileIndex.getFileID()));
        FileIndexManager.a();
    }

    private static void a() {
        BinaryOperator binaryOperator = (fileIndex, fileIndex2) -> {
            if (fileIndex2.getLastModified() >= fileIndex.getLastModified()) {
                return fileIndex2;
            }
            return fileIndex;
        };
        Map map = LIST.stream().collect(Collectors.toMap(FileIndex::getFileID, Function.identity(), binaryOperator));
        ID_MAP.clear();
        ID_MAP.putAll(map);
        Map map2 = LIST.stream().collect(Collectors.toMap(FileIndex::getPath, Function.identity(), binaryOperator));
        PATH_MAP.clear();
        PATH_MAP.putAll(map2);
    }
}

