/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.debugger;

import com.bokesoft.erp.webdesigner.language.common.Constants;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.Breakpoint;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.BreakpointManager;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.DebuggerContext;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.DebuggerWebsocketServer;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.ItemWrapper;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.OperateTypeEnum;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.SyntaxTreeExplainer;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.SyntaxTreeWrapper;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.parser.EvalScope;
import com.bokesoft.yes.parser.Heap;
import com.bokesoft.yes.parser.IEvalEnv;
import com.bokesoft.yes.parser.IExprDebugger;
import com.bokesoft.yes.parser.IFuncImplMap;
import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.SyntaxTree;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.parser.IEvalContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DesignerDebuggerImpl
implements IExprDebugger {
    private static final Set<EvalScope> CONDITION_SCOPES = new HashSet<EvalScope>();
    private static final Object LOCK = new Object();
    private static boolean enable = true;

    public <EC extends IEvalContext> void startExecSyntaxTree(IEvalEnv<EC> iEvalEnv, EC EC, IFuncImplMap iFuncImplMap, SyntaxTree syntaxTree, EvalScope evalScope) {
        if (this.a(true)) {
            return;
        }
        if (this.a(EC, evalScope)) {
            return;
        }
        DebuggerContext<EC> debuggerContext = DebuggerContext.getInstance();
        if (Objects.isNull(debuggerContext)) {
            SyntaxTreeWrapper<EC> syntaxTreeWrapper = new SyntaxTreeWrapper<EC>(iEvalEnv, EC, iFuncImplMap, syntaxTree, evalScope);
            SyntaxTreeExplainer.explain(syntaxTreeWrapper);
            Breakpoint breakpoint = this.a(syntaxTreeWrapper);
            if (Objects.isNull(breakpoint)) {
                return;
            }
            List<ItemWrapper> list = syntaxTreeWrapper.getVariantWrapperList();
            this.a(iEvalEnv, EC, evalScope, list);
            debuggerContext = DebuggerContext.build(syntaxTreeWrapper);
            debuggerContext.setRunningBreakpoint(breakpoint);
            DebuggerWebsocketServer.sendText("StartDebug");
            return;
        }
        SyntaxTreeWrapper syntaxTreeWrapper = new SyntaxTreeWrapper(iEvalEnv, EC, iFuncImplMap, syntaxTree, evalScope);
        SyntaxTreeExplainer.explain(syntaxTreeWrapper);
        List<ItemWrapper> list = syntaxTreeWrapper.getVariantWrapperList();
        this.a(iEvalEnv, EC, evalScope, list);
        ItemWrapper itemWrapper = syntaxTreeWrapper.getRootItemWrapper();
        SyntaxTreeWrapper syntaxTreeWrapper2 = debuggerContext.getRunningSyntaxTreeWrapper();
        syntaxTreeWrapper.setParentSyntaxTreeWrapper(syntaxTreeWrapper2);
        syntaxTreeWrapper.setRunningItemWrapper(itemWrapper);
        debuggerContext.setRunningSyntaxTreeWrapper(syntaxTreeWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <EC extends IEvalContext> void endExecSyntaxTree(IEvalEnv<EC> iEvalEnv, EC EC, SyntaxTree syntaxTree, EvalScope evalScope) {
        if (this.a(false)) {
            return;
        }
        if (this.a(evalScope)) {
            return;
        }
        DebuggerContext debuggerContext = DebuggerContext.getInstance();
        SyntaxTreeWrapper syntaxTreeWrapper = debuggerContext.getRunningSyntaxTreeWrapper();
        syntaxTreeWrapper.setCompleted(true);
        SyntaxTreeWrapper syntaxTreeWrapper2 = syntaxTreeWrapper.getParentSyntaxTreeWrapper();
        if (Objects.nonNull(syntaxTreeWrapper2)) {
            debuggerContext.setRunningSyntaxTreeWrapper(syntaxTreeWrapper2);
            return;
        }
        if (DebuggerContext.getOperateType() == OperateTypeEnum.STEP_OVER) {
            syntaxTreeWrapper.setRunningItemWrapper(syntaxTreeWrapper.getRootItemWrapper());
            Object object = LOCK;
            synchronized (object) {
                try {
                    LOCK.wait();
                }
                catch (Exception exception) {
                    LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
                }
            }
        }
        DebuggerContext.destroy();
    }

    public <EC extends IEvalContext> void startExecItem(IEvalEnv<EC> iEvalEnv, EC EC, EvalScope evalScope, Item item) {
        if (this.a(false)) {
            return;
        }
        if (this.a(evalScope)) {
            return;
        }
        DebuggerContext debuggerContext = DebuggerContext.getInstance();
        SyntaxTreeWrapper syntaxTreeWrapper = debuggerContext.getRunningSyntaxTreeWrapper();
        ItemWrapper itemWrapper = syntaxTreeWrapper.getItemWrapper(item);
        if (!itemWrapper.isNeedDisplay()) {
            return;
        }
        if (DebuggerContext.getOperateType() != OperateTypeEnum.HIT) {
            syntaxTreeWrapper.setRunningItemWrapper(itemWrapper);
        }
        this.a(EC, syntaxTreeWrapper, itemWrapper);
    }

    public <EC extends IEvalContext> void endExecItem(IEvalEnv<EC> iEvalEnv, EC EC, EvalScope evalScope, Item item, Object object) {
        SyntaxTreeWrapper syntaxTreeWrapper;
        ItemWrapper itemWrapper;
        DebuggerContext debuggerContext = DebuggerContext.getInstance();
        if (Objects.nonNull(debuggerContext) && Objects.nonNull(itemWrapper = (syntaxTreeWrapper = debuggerContext.getRunningSyntaxTreeWrapper()).getItemWrapper(item))) {
            itemWrapper.setCompleted(true);
            itemWrapper.setEvalResult(object);
        }
    }

    public static void setEnable(boolean bl) {
        enable = bl;
    }

    public static boolean getEnable() {
        return enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void operate(OperateTypeEnum operateTypeEnum) {
        Object object;
        if (operateTypeEnum == OperateTypeEnum.STEP_OUT && Objects.nonNull(object = DebuggerContext.getInstance())) {
            SyntaxTreeWrapper syntaxTreeWrapper = ((DebuggerContext)object).getRunningSyntaxTreeWrapper();
            syntaxTreeWrapper.setCompleted(true);
            ((DebuggerContext)object).setRunningSyntaxTreeWrapper(syntaxTreeWrapper.getParentSyntaxTreeWrapper());
        }
        DebuggerContext.setOperateType(operateTypeEnum);
        object = LOCK;
        synchronized (object) {
            try {
                LOCK.notifyAll();
            }
            catch (Exception exception) {
                LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <EC extends IEvalContext> void a(EC EC, SyntaxTreeWrapper<EC> syntaxTreeWrapper, ItemWrapper itemWrapper) {
        Object object;
        boolean bl = false;
        OperateTypeEnum operateTypeEnum = DebuggerContext.getOperateType();
        if (operateTypeEnum == OperateTypeEnum.STEP_OVER) {
            bl = true;
        }
        DebuggerContext debuggerContext = DebuggerContext.getInstance();
        SyntaxTreeWrapper syntaxTreeWrapper2 = debuggerContext.getRunningSyntaxTreeWrapper();
        if (operateTypeEnum == OperateTypeEnum.HIT) {
            bl = Objects.equals(itemWrapper, syntaxTreeWrapper2.getRunningItemWrapper());
        }
        if (operateTypeEnum == OperateTypeEnum.STEP_INTO) {
            bl = true;
        }
        if (operateTypeEnum == OperateTypeEnum.STEP_OUT && Objects.equals(syntaxTreeWrapper, syntaxTreeWrapper2)) {
            bl = true;
        }
        if (operateTypeEnum == OperateTypeEnum.RESUME && Objects.nonNull(object = this.a(EC, itemWrapper.getFormatText()))) {
            debuggerContext.setRunningBreakpoint((Breakpoint)object);
            bl = true;
        }
        if (!bl) {
            return;
        }
        object = LOCK;
        synchronized (object) {
            try {
                LOCK.wait();
            }
            catch (Exception exception) {
                LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private <EC extends IEvalContext> Breakpoint a(SyntaxTreeWrapper<EC> syntaxTreeWrapper) {
        ItemWrapper itemWrapper = syntaxTreeWrapper.getRootItemWrapper();
        Breakpoint breakpoint = this.a((IEvalContext)syntaxTreeWrapper.getContext(), itemWrapper.getFormatText());
        if (Objects.isNull(breakpoint)) {
            return null;
        }
        Map<Item, ItemWrapper> map = syntaxTreeWrapper.getItemWrapperMap();
        for (ItemWrapper itemWrapper2 : map.values()) {
            Breakpoint breakpoint2;
            if (!itemWrapper2.isNeedDisplay() || !Objects.nonNull(breakpoint2 = this.a((IEvalContext)syntaxTreeWrapper.getContext(), itemWrapper2.getFormatText()))) continue;
            syntaxTreeWrapper.setRunningItemWrapper(itemWrapper2);
            return breakpoint2;
        }
        syntaxTreeWrapper.setRunningItemWrapper(itemWrapper);
        return breakpoint;
    }

    private Breakpoint a(IEvalContext iEvalContext, String string) {
        Predicate<Breakpoint> predicate = breakpoint -> breakpoint.isExpr() && breakpoint.getEnable() != false;
        List list = BreakpointManager.getList().stream().filter(predicate).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        for (Breakpoint breakpoint2 : list) {
            boolean bl;
            String string2 = breakpoint2.getOptimizedText();
            if (string2.length() > string.length() || !(bl = StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)string2))) continue;
            String string3 = breakpoint2.getCondition();
            if (StringUtils.isBlank((CharSequence)string3)) {
                return breakpoint2;
            }
            if (!(iEvalContext instanceof RichDocumentContext)) continue;
            RichDocumentContext richDocumentContext = (RichDocumentContext)iEvalContext;
            try {
                EvalScope evalScope = new EvalScope();
                CONDITION_SCOPES.add(evalScope);
                Object object = richDocumentContext.evalFormula(string3, "", evalScope);
                Boolean bl2 = TypeConvertor.toBoolean((Object)object);
                if (!bl2.booleanValue()) continue;
                Breakpoint breakpoint3 = breakpoint2;
                return breakpoint3;
            }
            catch (Throwable throwable) {
                LogSvr.getInstance().error(throwable.getMessage(), throwable);
            }
            finally {
                CONDITION_SCOPES.clear();
            }
        }
        return null;
    }

    private <EC extends IEvalContext> void a(IEvalEnv<EC> iEvalEnv, EC EC, EvalScope evalScope, List<ItemWrapper> list) {
        for (ItemWrapper itemWrapper : list) {
            Heap heap;
            Item item = itemWrapper.getItem();
            Item item2 = item.getFactor(0);
            String string = item2.getObj();
            String string2 = item2.getLexValue();
            boolean bl = false;
            Object object = null;
            if (evalScope != null && (heap = evalScope.getHeap()).containVariable(string2)) {
                object = heap.getVariable(string2);
                bl = true;
            }
            if (!bl) {
                try {
                    object = iEvalEnv.getValue(EC, evalScope, string, string2);
                }
                catch (Throwable throwable) {
                    LogSvr.getInstance().error(throwable.getMessage(), throwable);
                }
            }
            itemWrapper.setEvalResult(object);
        }
    }

    private <EC extends IEvalContext> boolean a(boolean bl) {
        if (!enable || DebuggerWebsocketServer.notExistClient()) {
            DebuggerContext.destroy();
            return true;
        }
        DebuggerContext debuggerContext = DebuggerContext.getInstance();
        if (Objects.isNull(debuggerContext)) {
            if (bl) {
                return false;
            }
            DebuggerContext.destroy();
            return true;
        }
        if (DebuggerContext.getOperateType() == OperateTypeEnum.OFF) {
            DebuggerContext.destroy();
            return true;
        }
        if (bl) {
            return DebuggerContext.getOperateType() != OperateTypeEnum.STEP_INTO;
        }
        return false;
    }

    private <EC extends IEvalContext> boolean a(EvalScope evalScope) {
        DebuggerContext debuggerContext = DebuggerContext.getInstance();
        if (Objects.isNull(debuggerContext)) {
            return true;
        }
        SyntaxTreeWrapper syntaxTreeWrapper = debuggerContext.getRunningSyntaxTreeWrapper();
        return evalScope != syntaxTreeWrapper.getScope();
    }

    private <EC extends IEvalContext> boolean a(IEvalContext iEvalContext, EvalScope evalScope) {
        RichDocumentContext richDocumentContext;
        if (CONDITION_SCOPES.contains(evalScope)) {
            return true;
        }
        EvalScope evalScope2 = evalScope.getParent();
        if (CONDITION_SCOPES.contains(evalScope2)) {
            CONDITION_SCOPES.add(evalScope);
            return true;
        }
        DebuggerContext debuggerContext = DebuggerContext.getInstance();
        if (Objects.nonNull(debuggerContext) && evalScope != (richDocumentContext = debuggerContext.getRunningSyntaxTreeWrapper()).getScope() && evalScope.getParent() != richDocumentContext.getScope()) {
            return true;
        }
        if (!(iEvalContext instanceof RichDocumentContext)) {
            return true;
        }
        richDocumentContext = (RichDocumentContext)iEvalContext;
        String string = richDocumentContext.getFormKey();
        if (StringUtils.isBlank((CharSequence)string)) {
            return true;
        }
        IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
        try {
            MetaForm metaForm = iMetaFactory.getMetaForm(string);
            return Constants.EXCLUDE_PROJECT_LIST.contains(metaForm.getProjectKey());
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
            return true;
        }
    }
}

