/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.debugger;

import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.Breakpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BreakpointManager {
    private static final List<Breakpoint> LIST = Collections.synchronizedList(new ArrayList());

    public static Breakpoint get(long l) {
        Predicate<Breakpoint> predicate = breakpoint -> Objects.equals(breakpoint.getOid(), l);
        Optional<Breakpoint> optional = LIST.stream().filter(predicate).findFirst();
        return optional.orElse(null);
    }

    public static List<Breakpoint> getList() {
        return LIST;
    }

    public static void save(Breakpoint breakpoint) {
        if (!LIST.contains(breakpoint)) {
            LIST.add(breakpoint);
        }
    }

    public static void addAll(Collection<Breakpoint> collection) {
        LIST.addAll(collection);
    }

    public static void delete(Long l) {
        LIST.removeIf(breakpoint -> Objects.equals(breakpoint.getOid(), l));
    }

    public static void clear() {
        LIST.clear();
    }
}

