/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.common;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.function.Function;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHelper {
    public static void parse(File file, DefaultHandler defaultHandler) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(file, defaultHandler);
    }

    public static <T> void transform(File file, String string, Collection<T> collection, Function<T, Attributes> function) throws Exception {
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileOutputStream fileOutputStream = FileUtils.openOutputStream((File)file);){
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformerHandler.setResult(streamResult);
            Transformer transformer = transformerHandler.getTransformer();
            transformer.setOutputProperty("version", "1.0");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformerHandler.startDocument();
            transformerHandler.characters("\n".toCharArray(), 0, "\n".length());
            transformerHandler.startElement("", "", String.valueOf(string) + "Collection", new AttributesImpl());
            for (T t : collection) {
                Attributes attributes = function.apply(t);
                transformerHandler.characters("\n  ".toCharArray(), 0, "\n  ".length());
                transformerHandler.startElement("", "", string, attributes);
                transformerHandler.endElement("", "", string);
            }
            transformerHandler.characters("\n".toCharArray(), 0, "\n".length());
            transformerHandler.endElement("", "", String.valueOf(string) + "Collection");
            transformerHandler.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

