/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.application.model;

import com.bokesoft.erp.webdesigner.language.infrastructure.index.FileIndex;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.FileIndexManager;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFileWrapper;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndex;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class KeyPosition {
    private String a;
    private String b;
    private String c;
    private String d;
    private int e;
    private int f;
    private String g;

    public String getFilePath() {
        return this.a;
    }

    public void setFilePath(String string) {
        this.a = string;
    }

    public String getFileCaption() {
        return this.b;
    }

    public void setFileCaption(String string) {
        this.b = string;
    }

    public String getKey() {
        return this.c;
    }

    public void setKey(String string) {
        this.c = string;
    }

    public String getCaption() {
        return this.d;
    }

    public void setCaption(String string) {
        this.d = string;
    }

    public int getLine() {
        return this.e;
    }

    public void setLine(int n) {
        this.e = n;
    }

    public int getColumn() {
        return this.f;
    }

    public void setColumn(int n) {
        this.f = n;
    }

    public String getSnapshot() {
        return this.g;
    }

    public void setSnapshot(String string) {
        this.g = string;
    }

    public static KeyPosition create(KeyIndex keyIndex) {
        return KeyPosition.create(keyIndex, null);
    }

    public static KeyPosition create(KeyIndex keyIndex, String string) {
        KeyPosition keyPosition = new KeyPosition();
        if (Objects.isNull(keyIndex)) {
            return keyPosition;
        }
        FileIndex fileIndex = FileIndexManager.get(keyIndex.getFileID());
        if (Objects.nonNull(fileIndex)) {
            keyPosition.setFileCaption(fileIndex.getCaption());
            keyPosition.setFilePath(IndexFileWrapper.toFrontFilePath(fileIndex.getPath()));
        }
        keyPosition.setKey(keyIndex.getKey());
        keyPosition.setCaption(StringUtils.isNotBlank((CharSequence)string) ? string : keyIndex.getCaption());
        keyPosition.setLine(keyIndex.getLine());
        keyPosition.setColumn(keyIndex.getColumn());
        keyPosition.setSnapshot(StringUtils.trim((String)keyIndex.getSnapshot()));
        return keyPosition;
    }
}

